;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SET_PREVIOUS
;
; Purpose     :	Saves previous info structure.
;
; Explanation : Saves previous info structure.
;
; Use         : < RCS_SET_PREVIOUS,previous >
;
; Inputs      : previous : STRUCTURE giving info
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : SC : Flag indicating science stream
;               HK : Flag indicating housekeeping stream
;
; Written     :	Version 0.0, 12/2/01
;
; Modified    : None.
;
; Version     :	Version 0.0, 12/2/01
;-
;**********************************************************

PRO rcs_set_previous, previous, SC=sc, HK=hk

  COMMON rcs_previous_local, previous_sc, previous_hk

  ; save previous info

  IF KEYWORD_SET(sc) THEN BEGIN

    previous_sc = previous

  ENDIF ELSE IF KEYWORD_SET(hk) THEN BEGIN

    previous_hk = previous

  ENDIF ELSE rcs_message,/IMPLEMENTATION

END
