;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SET_SOURCE
;
; Purpose     :	Sets source.
;
; Explanation : Sets source.
;
; Use         : < RCS_SET_SOURCE, source>
;
; Inputs      : source : STRING
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 23/07/01
;
; Modified    : Version 0.1, 04/07/02
;                 Added SCI source.
;               Version 0.2, 02/09/03
;                 Changed to 3 character source ID : previously w = SCI, x = DAT, y = GSE, z = DDS
;
; Version     :	Version 0.2, 02/09/03
;-
;**********************************************************

PRO rcs_set_source, input

  COMMON rcs_source_local, source

  ; save source

  ; set up source filter

  CASE input OF

    'SCI'   : source = 'sci'

    'DAT'   : source = 'dat'

    'GSEOS' : source = 'gse'

    'DDS'   : source = 'dds'

    ELSE : source = input

  ENDCASE

END
