;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SORT_DAYS
;
; Purpose     :	Sorts and selects days from days list.
;
; Explanation : Sorts and selects days from days list.
;               If no days selected then returns ''.
;               input_days may have additional characters which are used for sorting and determining
;               uniqueness.
;
; Use         : < list = rcs_sort_days(days)>
;
; Inputs      : days  : STRARR list of days in form yymmddxxxxxx
;                       
;
; Opt. Inputs : None.
;
; Outputs     : days  : STRARR selected, sorted days in form yymmdd
;
; Opt. Outputs: None.
;
; Keywords    : TSTART : STRING start date in form yymmdd.
;               TSTOP  : STRING stop date in form yymmdd.
;               COUNT  : INT containing no of selected days.
;
; Written     :	Version 0.0, Martin Carter, RAL, 22/03/01
;
; Modified    : Version 0.1, 02/06/01
;                 Fixed bug processing tstop.
;               Version 0.2, 06/02/02
;                 Added DAYS and YYYY keywords.
;               Version 0.3, 13/05/02
;                 Used rcs_to_yyyymmdd.
;
; Version     :	Version 0.3, 13/05/02
;-
;**********************************************************

FUNCTION rcs_sort_days, input_days, TSTART=tstart, TSTOP=tstop, COUNT=count, DAYS=days, YYYY=yyyy

  ; get internal copy


  IF NOT KEYWORD_SET(yyyy) THEN BEGIN

    days = rcs_to_yyyymmdd(input_days)

  ENDIF ELSE BEGIN

    days = input_days

  ENDELSE

  ; sort into day order

  list = SORT(days)

  ; remove duplicates

  l = UNIQ(days[list])

  list = list[l]

  count = N_ELEMENTS(list)

  ; remove any extensions

  days[list] = STRMID(days[list],0,8)

  ; select days required

  IF KEYWORD_SET(tstart) THEN BEGIN

    ttstart = rcs_to_yyyymmdd(tstart)

    l = WHERE(days[list] GE ttstart,count)

    IF count GT 0 THEN list = list[l] ELSE list = [-1]

  ENDIF

  IF KEYWORD_SET(tstop) AND count GT 0 THEN BEGIN

    ttstop = rcs_to_yyyymmdd(tstop)

    l = WHERE(days[list] LE ttstop,count)

    IF count GT 0 THEN list = list[l] ELSE list = [-1]

  ENDIF

  RETURN, list

END
