;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SURVEY_PLOTS
;
; Purpose     :	Does standard survey plots.
;
; Explanation : Does standard survey plots.
;
; Use         : < RCS_SURVEY_PLOTS, root, sc, day >
;
; Inputs      : root : STRING specifying root output directory  i.e 'PNG'
;               sc   : STRING character giving SC or ''
;               day  : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : PNG : Flag indicating PNG output
;               GIF : Flag indicating GIF output
;
; Written     :	Version 0.0, Martin Carter, RAL, 29/07/02
;                 Separated from rcs_batch_process.
;
; Modified    :	Version 0.1, 07/11/03
;                 Modified argument list.
;
; Version     :	Version 0.1, 07/11/03
;-
;**********************************************************

PRO rcs_survey_plots, root, sc, day, PNG=png, GIF=gif

  ; do standard survey plots
  ; fool routine into getting name right

  day_start = anytim2tai(STRMID(day,0,2)+'/'+STRMID(day,2,2)+'/'+STRMID(day,4,2))

  FOR q = 0, rcs_get_nplots() DO BEGIN

    IF q EQ 0 THEN BEGIN

      t0 = day_start
      t1 = day_start + 86400L

    ENDIF ELSE BEGIN

      duration = 86400L/rcs_get_nplots()
      t0 = day_start + (q-1)*duration
      t1 = day_start + q*duration

    ENDELSE

    subdir = rcs_batch_output_dir(root, sc, 'survey_ies_survey.cfg', rcs_strtrim(q))

    IF NOT KEYWORD_SET(subdir) THEN RETURN

    dummy = rcs_batch_output_file(day, subdir, PNG=png, GIF=gif)

    rcs_survey, TYPE=0, PNG=png, GIF=gif, T0=t0, T1=t1

    subdir = rcs_batch_output_dir(root, sc, 'survey_clean_survey.cfg', rcs_strtrim(q))

    IF NOT KEYWORD_SET(subdir) THEN RETURN

    dummy = rcs_batch_output_file(day, subdir, PNG=png, GIF=gif)

    rcs_survey, TYPE=5, PNG=png, GIF=gif, T0=t0, T1=t1

    subdir = rcs_batch_output_dir(root, sc, 'survey_iesbm_survey.cfg', rcs_strtrim(q))

    IF NOT KEYWORD_SET(subdir) THEN RETURN

    dummy = rcs_batch_output_file(day, subdir, PNG=png, GIF=gif)

    rcs_survey, TYPE=4, PNG=png, GIF=gif, T0=t0, T1=t1

  ENDFOR

END
