;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS
;
; Purpose     :	Launches RAPID COMMISSIONING SW WIDGET.
;
; Explanation : Sets up widget for RAPID data input.
;               Allows input of either CDDS or GSEOS format data.
;               Default is CDDS data format.
;
; Use         : < rcs >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : GSEOS : Flag indicating GSEOS data.
;               DDS   : Flag indicating DDS data.
;               DAT   : Flag indicating DAT data.
;               SCI   : Flag indicating SCI data.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;                 Added OPEN CD.
;                 Added SC number to S/C selection droplist.
;                 Added DAT data option.
;                 Added type to ids.
;                 Moved timerid to ids.sc.
;                 Added input tag to ids for storing info.
;                 Added BATCH IF command.
;                 Added CONCATENATE IF command
;               Version 0.2, 6/2/01
;                 Added PEDESTAL and ESPCT IF data set
;               Version 0.3, 10/2/01
;                 Changed silent and batch to common blocks.
;                 Changed files to common block.
;                 Changed start to common block.
;                 Changed sc previous and hk previous to common block.
;                 Added OPEN DAT option.
;               Version 0.4, 21/2/01
;                 Removed SC selection from DDS and DAT versions.
;                 Changed BATCH to AUTO in commands.
;                 Added RCS DATA DIRECTORY field.
;               Version 0.5, 5/3/01
;                 Added TRIM IF command.
;               Version 0.6, 9/3/01
;                 Added SAVE/RESTORE IF_CFG commands.
;                 Added SPCT survey plot.
;                 Added FORCE button.
;               Version 0.7, 16/03/01
;                 Added set ies_ncolors.
;               Version 0.8, 08/04/01
;                 Added REPROCESS IF.
;               Version 0.9, 03/05/01
;                 Added RESTORE_SINGLE_IF command.
;                 Added DETECTOR vs SECTOR survey plot
;               Version 1.0, 15/05/01
;                 Added CLEANBM2.
;                 Moved rcs_initialize_common to cure bug with display of use.
;                 Removed initialization of start and auto.
;                 Added IES BM survey plot.
;               Version 1.1, 26/06/01
;                 Added IES CLEAN survey plot.
;               Version 1.2, 08/02/02
;                 Added EPAD2. Removed MIS.
;               Version 1.3, 14/05/02
;                 Added PA, LINE and OCC 4SC survey plots.
;               Version 1.4, 12/07/02
;                 Added SCI data source.
;               Version 1.5, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 1.5, 09/10/03
;-
;**********************************************************

PRO rcs, DDS=dds, GSEOS=gseos, DAT=dat, SCI=sci

  ; set up no of colors and color table

  dummy = ies_ncolors(/SET, SHARED=39)

  IF KEYWORD_SET(gseos) THEN BEGIN
    ids = {base:0L, text:0L, sc:0L, hk:0L, block:0L, start:0L, spacecraft:0L, type:'GSEOS', $
           in:{FILE, type:'GSEOS', file:0L, bytes:0L, time:0L}, $
           skipid:0L, skiptime:0L, showedb:0L, time:0L, instrument:0L, $
           showif:0L, info:0L, auto:0L, datadir:0L}
  ENDIF ELSE IF KEYWORD_SET(dat) THEN BEGIN
    ids = {base:0L, text:0L, sc:0L, hk:0L, block:0L, start:0L, spacecraft:0L, type:'DAT', $
           in:REPLICATE({FILE, type:'EDB', file:0L, bytes:0L, time:0L},2), $
           skipid:0L, skiptime:0L, showedb:0L, time:0L, instrument:0L, $
           showif:0L, info:0L, auto:0L, datadir:0L}
    ids.in[1].type = 'HK'
  ENDIF ELSE IF KEYWORD_SET(sci) THEN BEGIN
    ids = {base:0L, text:0L, sc:0L, hk:0L, block:0L, start:0L, spacecraft:0L, type:'SCI', $
           skipid:0L, skiptime:0L, showedb:0L, time:0L, instrument:0L, $
           showif:0L, info:0L, auto:0L, datadir:0L}
  ENDIF ELSE BEGIN
    dds = 1
    ids = {base:0L, text:0L, sc:0L, hk:0L, block:0L, start:0L, spacecraft:0L, type:'DDS', $
           in:REPLICATE({FILE, type:'NM', file:0L, bytes:0L, time:0L},3), $
           skipid:0L, skiptime:0L, showedb:0L, time:0L, instrument:0L, $
           showif:0L, info:0L, auto:0L, datadir:0L}
    ids.in[1].type = 'BM'
    ids.in[2].type = 'HK'
  ENDELSE

  ; set base ID of widget

  res = rcs_machine(0)

  ids.base = WIDGET_BASE(TITLE='RAPID COMMISSIONING SOFTWARE', /COL, /SCROLL,$
               X_SCROLL_SIZE=res.rcs_xsize, Y_SCROLL_SIZE=res.rcs_ysize)

  ; set up widget font

  dummy = rcs_machine(/FONT)

  ; set up rcs_in frame

  one  = WIDGET_BASE ( ids.base, /COL, /FRAME)

  ; make row group for buttons

  first_row  = WIDGET_BASE ( one, /ROW)

  ; make column group

  col = WIDGET_BASE ( first_row, /COL)

  ; set up logo

  logo   = ies_logo()
  dims   = SIZE(logo)
  logoid = WIDGET_DRAW ( col, XSIZE=dims(1), YSIZE=dims(2),RETAIN=2)

  buttons = WIDGET_BASE(col, /COL, /NONEXCLUSIVE)

  ; set up FORCE button

  dummy = WIDGET_BUTTON ( buttons, UVALUE='FORCE', VALUE='FORCE')

  ; SKIP only available in DDS mode
  ; create dummy base with UVALUE=0 for GSEOS mode

  IF KEYWORD_SET(dds) THEN BEGIN

    ids.skipid = WIDGET_BUTTON ( buttons, UVALUE='SKIP', VALUE='SKIP')

    ids.skiptime = WIDGET_TEXT(col, XSIZE=5, VALUE='', UVALUE=0, /EDITABLE, EVENT_PRO='rcs_dummy_event')

  ENDIF ELSE BEGIN

    ids.skiptime = WIDGET_BASE(col, UVALUE=0)

  ENDELSE

  row = WIDGET_BASE(col, /ROW, /NONEXCLUSIVE)

  silent_id = WIDGET_BUTTON ( row, UVALUE='SILENT', VALUE='SILENT')

  ; make column group

  col = WIDGET_BASE ( first_row, /COL)

  ; make row group

  row1 = WIDGET_BASE ( col, /ROW)

  ; set up pull down menu

  IF KEYWORD_SET(gseos) THEN $
    wording = '0\OPEN GSEOS' $
  ELSE IF KEYWORD_SET(dat) THEN $
    wording = ['0\OPEN EDB', '0\OPEN HK', '0\OPEN DAT', '0\AUTO', '0\AUTO IF'] $
  ELSE IF KEYWORD_SET(sci) THEN $
    wording = ['0\PROCESS SCI'] $
  ELSE $
    wording = ['0\OPEN NM', '0\OPEN BM','0\OPEN HK', '0\OPEN CD', '0\AUTO', '0\AUTO IF']

  survey_list = ['0\IES',        $
                 '0\CLEAN',      $
                 '0\IIMS',       $
                 '0\SGL',        $
                 '0\SPCT',       $
                 '0\IESBM',      $
                 '3\4SC',        $
                 '0\IES',        $
                 '0\IIMS',       $
                 '0\POL',        $
                 '0\PA',         $
;                 '0\LINE',       $
                 '2\OCC']

  items = [  '1\MENU',       $
             '0\START',      $
             '0\PLOT',       $
             wording,        $
             '0\RESET',      $
             '0\RESET_TEXT', $
             '0\STOP',       $
             '0\SAVE_IF',    $
             '0\RESTORE_IF', $
             '0\RESTORE_SINGLE_IF', $
             '0\TRIM IF',    $
             '0\PROCESS IF', $
             '0\REPROCESS IF', $
             '0\CONCATENATE IF', $
             ; '0\RESTORE_DAT', $
             '0\SAVE_CONFIGURATION',  $
             '0\RESTORE_CONFIGURATION', $
             '0\SAVE_IF_CONFIGURATION',  $
             '0\RESTORE_IF_CONFIGURATION', $
             '0\COLOR',      $
             '1\SURVEY',     $
             '1\WIN',        $
             survey_list,    $
             '1\PS',         $
             survey_list,    $
             '1\GIF',        $
             survey_list,    $
             '3\PNG',        $
             survey_list,    $
             '1\RAL PLOT TOOL', $
             '0\E-3DD',      $
             '0\E-3DDBM',    $
             '0\E-PAD',      $
             '0\E-PAD2',     $
             '0\E-HIST',     $
             '0\CLEAN',      $
             '0\CLEANBM',    $
             '0\CLEANBM2',   $
             '0\ESPCT',    $
             '0\PEDESTAL',   $
             '0\E-HK',       $
             '0\HK1',        $
             '0\HK2',        $
             '0\HK4',        $
             '0\HK8',        $
             '0\HK32',       $
             '0\I-3DD-H',    $
             '0\I-3DD-He',   $
             '0\I-3DD-CNO',  $
             '0\I-PAD',      $
             '0\HSPCT',      $
             '0\ISPCT-He',   $
             '0\ISPCT-CNO',  $
             '0\MTRX',       $
             '0\SGLBM',      $
             '0\SGL01',      $
             '0\SGL2',       $
             '2\SGL3',       $
             '2\QUIT'        ]

  dummy = CW_PDMENU ( row1, items, UVALUE='MENU', /RETURN_FULL_NAME)

  row1b = WIDGET_BASE(row1, /ROW, /NONEXCLUSIVE)

  ids.block = WIDGET_BUTTON(row1b, VALUE='BLOCKED', UVALUE=0)

  rcs_sensitive, ids.block, 0

  ids.start = WIDGET_BUTTON(row1b, VALUE='GOING')

  rcs_sensitive, ids.start, 0

  ; set auto button

  IF KEYWORD_SET(dds) OR KEYWORD_SET(dat) THEN BEGIN

    ; set uvalue to the value of the button

    ids.auto = WIDGET_BUTTON(row1b, VALUE='AUTO')

    rcs_sensitive, ids.auto, 0

  ENDIF

  dummy = WIDGET_LABEL(row1, VALUE='SC')

  ids.sc = WIDGET_TEXT(row1, XSIZE=9, YSIZE=1, VALUE='', EVENT_PRO='rcs_timer')

  dummy = WIDGET_LABEL(row1, VALUE='HK')

  ids.hk = WIDGET_TEXT(row1, XSIZE=9, YSIZE=1, VALUE='')

  ; set up droplist

  IF KEYWORD_SET(gseos) THEN BEGIN

    list = [ '0:PHOENIX',  $
             '1:RAP_F8',   $
             '2:RAP_F1',   $
             '3:RAP_F6',   $
             '4:RAP_F7',   $
             '5:RAP_F9'   ]

    ids.spacecraft = WIDGET_DROPLIST ( row1, VALUE=list, UVALUE='S/C')

    WIDGET_CONTROL, ids.spacecraft, SET_DROPLIST_SELECT=0

  ENDIF

  IF ies_tag_exists(ids,'IN') THEN BEGIN

    FOR k = 0, N_ELEMENTS(ids.in)-1 DO BEGIN

      ; next row

      row = WIDGET_BASE(col, /ROW)

      dummy = WIDGET_LABEL(row, VALUE=ids.in[k].type)

      ids.in[k].file = WIDGET_TEXT(row, XSIZE=40, YSIZE=2, VALUE='')

      dummy = WIDGET_LABEL(row, VALUE='BYTES READ')

      ids.in[k].bytes = WIDGET_TEXT(row, XSIZE=9, YSIZE=1, VALUE='')

      dummy = WIDGET_LABEL(row, VALUE='TIME')

      ; nb make time two rows to allow next header time to be displayed

      ids.in[k].time = WIDGET_TEXT(row, XSIZE=20, YSIZE=2, VALUE='')

    ENDFOR

  ENDIF

  ; RCS DATA DIRECTORY

  row = WIDGET_BASE(one, /ROW)

  dummy = WIDGET_LABEL(row, VALUE='RCS DATA DIRECTORY : ')

  ids.datadir = WIDGET_TEXT(row, XSIZE=70, VALUE=ies_get_dir('DATA',/RAPID))

  dummy = WIDGET_BUTTON(row, VALUE='BROWSE',UVALUE='BROWSE')

  ; rcs_extract frame

  two = WIDGET_BASE ( ids.base, /COL, /FRAME)

  row = WIDGET_BASE ( two, /ROW)

  ; EDB info

  ids.showedb = rcs_cw_showedb(row)

  ; rcs_plot

  ids.showif = rcs_cw_showif(two)

  ; rcs_plot frame

  three = WIDGET_BASE ( ids.base, /COL, /FRAME)

  ; info display

  ids.info = rcs_cw_info(three)

  ; create widget for text output
  ; use UVALUE to store no of lines

  ids.text = WIDGET_TEXT(ids.base, XSIZE=80, YSIZE=10, /SCROLL, /WRAP, UVALUE=0)

  ; realize the widget

  WIDGET_CONTROL, ids.base, /REALIZE

  ; save widget IDs

  rcs_set_ids, ids

  ; initialize common blocks

  rcs_initialize_common, ids

  ; set blocked button off

  WIDGET_CONTROL, ids.block, SET_BUTTON=0

  ; set skip button off

  IF KEYWORD_SET(dds) THEN WIDGET_CONTROL, ids.skipid, SET_BUTTON=0

  ; set silent button off

  WIDGET_CONTROL, silent_id, SET_BUTTON=0

  ; set output_info

  WIDGET_CONTROL, ids.info, SET_VALUE=rcs_output_info()

  ; set up logo

  WIDGET_CONTROL, logoid, GET_VALUE=win

  WSET, win

  TV, logo

  ; start processing events

  XMANAGER, 'rcs', ids.base, /NO_BLOCK

  ; send event to event manager

  WIDGET_CONTROL, ids.sc, TIMER=0.0

END
