;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_CHECK_SAVEFILE
;
; Purpose     :	Checks existence of save file for batch processing.
;
; Explanation : Checks existence of save file for batch processing.
;
; Use         : < res = rcs_batch_setup_days=(sc,savename,days,save_file) >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/05/02
;
; Modified    : Version 0.1, 05/07/02
;                 Used new routine ies_file_exists.
;               Version 0.2, 07/11/03
;                 Changed rcs get ifdir to rcs get subdir.
;
; Version     :	Version 0.2, 07/11/03
;-
;**********************************************************

FUNCTION rcs_batch_check_savefile, sc, savename, save_file

  dir = rcs_get_subdir('IF', sc)

  IF NOT KEYWORD_SET(dir) THEN RETURN, 0

  save_file = concat_dir( dir, savename)

  ; test if save_file already exists

  RETURN, ies_file_exists(save_file)

END
