;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_MCP
;
; Purpose     :	Batch process IF files.
;
; Explanation : Batch process IF files.
;
; Use         : < rcs_batch_mcp, ids >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILES : STRARR containing IF file names for processing.
;
; Written     :	Version 0.0, 12/06/01
;
; Modified    : Version 0.1, 25/06/01
;                 Saved all modes to a single file.
;                 Added mode4 and mode5.
;                 Added COMPRESS keyword to SAVE.
;               Version 0.2, 20/07/01
;                 Used rcs_sort_days.
;                 Used extended IF naming convention.
;                 Replaced keyword FILES with DAYS.
;                 Added keyword SC to argument list.
;               Version 0.3, 13/05/02
;                 Used rcs_to_yyyymmdd.
;                 Renamed routine from rcs_mcp.
;                 Added routine rcs_batch_setup_days.
;
; Version     :	Version 0.3, 13/05/02
;-
;**********************************************************

PRO rcs_batch_mcp, ids, sc, days, MCP_PROCESS=mcp_process

  COMMON rcs_mcp_process_block, mode0, mode1, mode2, mode3, mode4, mode5

  mode0 = 0
  mode1 = 0
  mode2 = 0
  mode3 = 0
  mode4 = 0
  mode5 = 0

  last_time = 0.0d0

  ; check if savefile exists

  IF rcs_batch_check_savefile(sc,'mcp_modes'+rcs_strtrim(mcp_process)+'.dat', save_file) THEN BEGIN

    RESTORE, save_file

    ; get last time processed

    IF KEYWORD_SET(mode0) THEN last_time = MAX([last_time,mode0[N_ELEMENTS(mode0)-1].time])
    IF KEYWORD_SET(mode1) THEN last_time = MAX([last_time,mode1[N_ELEMENTS(mode1)-1].time])
    IF KEYWORD_SET(mode2) THEN last_time = MAX([last_time,mode2[N_ELEMENTS(mode2)-1].time])
    IF KEYWORD_SET(mode3) THEN last_time = MAX([last_time,mode3[N_ELEMENTS(mode3)-1].time])
    IF KEYWORD_SET(mode4) THEN last_time = MAX([last_time,mode4[N_ELEMENTS(mode4)-1].time])
    IF KEYWORD_SET(mode5) THEN last_time = MAX([last_time,mode5[N_ELEMENTS(mode5)-1].time])

  ENDIF

  ; get days for processing

  IF NOT rcs_batch_setup_days(sc, last_time, days) THEN RETURN

  ; loop through files

  ids = rcs_get_ids()

  ; if interactive then set hourglass

  IF KEYWORD_SET(ids) THEN IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

    rcs_text, 'MCP PROCESSING '+days[k], /OVERRIDE

    ; reset IF data (in case already data)

    rcs_reset_if

    ; reprocess data

    rcs_mcp_process_if, sc, days[k], MCP_PROCESS=mcp_process

    ; reset IF data

    rcs_reset_if

  ENDFOR

  IF NOT KEYWORD_SET(mode0) AND NOT KEYWORD_SET(mode1) AND NOT KEYWORD_SET(mode2) $
    AND NOT KEYWORD_SET(mode3) AND NOT KEYWORD_SET(mode4) AND NOT KEYWORD_SET(mode5) $
      THEN RETURN

  ; save data

  SAVE, mode0, mode1, mode2, mode3, mode4, mode5, FILE=save_file, /COMPRESS

  HELP, mode0, mode1, mode2, mode3, mode4, mode5

  ; generate plots

  rcs_mcp_plot, sc, /PNG, MCP_PROCESS=mcp_process

END
