;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_PEDESTAL
;
; Purpose     :	Batch process IF files.
;
; Explanation : Batch process IF files.
;
; Use         : < rcs_batch_pedestal, ids >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILES : STRARR containing IF file names for processing.
;
; Written     :	Version 0.0, 17/05/02
;
; Modified    : Version 0.1, 07/11/03
;                 Changed rcs get ifdir to rcs get subdir.
;
; Version     :	Version 0.1, 07/11/03
;-
;**********************************************************

PRO rcs_batch_pedestal, ids, sc, days, PED_PROCESS=ped_process

  COMMON rcs_ped_process_block, peds

  peds = 0

  last_time = 0.0d0

  ; check if savefile exists

  IF rcs_batch_check_savefile(sc, 'peds.dat', save_file) THEN BEGIN

    RESTORE, save_file

    ; get last time processed

    IF KEYWORD_SET(peds) THEN last_time = peds[N_ELEMENTS(peds)-1].time

  ENDIF

  ; get days for processing

  IF NOT rcs_batch_setup_days(sc, last_time, days) THEN RETURN

  ; loop through files

  ids = rcs_get_ids()

  ; if interactive then set hourglass

  IF KEYWORD_SET(ids) THEN IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

    rcs_text, 'PEDESTAL PROCESSING '+days[k], /OVERRIDE

    ; reset IF data (in case already data)

    rcs_reset_if

    ; reprocess data

    rcs_ped_process_if, sc, days[k], PED_PROCESS=ped_process

    ; reset IF data

    rcs_reset_if

  ENDFOR

  IF NOT KEYWORD_SET(peds) THEN RETURN

  dir = rcs_get_subdir('IF', sc)

  IF NOT KEYWORD_SET(dir) THEN RETURN

  SAVE, peds, FILE=save_file, /COMPRESS

  HELP, peds

  ; generate plots

  rcs_pedestal_plot, sc, /PNG

END
