;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_SETUP_DAYS
;
; Purpose     :	Sets up days for batch processing.
;
; Explanation : Sets up days for batch processing.
;               If no valid days then returns 0 else returns 1.
;
; Use         : < res = rcs_batch_setup_days=(sc,savename,days,save_file) >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/05/02
;
; Modified    : 
;
; Version     :	Version 0.0, 17/05/02
;-
;**********************************************************

FUNCTION rcs_batch_setup_days, sc, last_time, days

  ; NB days can be '' in which case KEYWORD_SET(days) returns 0

  IF N_ELEMENTS(days) EQ 0 THEN rcs_get_days, sc, days

  IF days[0] EQ '' THEN RETURN, 0

  ; omit days already processed

  IF last_time GT 0.0d0 THEN BEGIN

    ; get day in form yyyymmdd

    last_day = anytim2cal(last_time,/DATE,FORM=8) 
     
    ; add century to days

    new_days = rcs_to_yyyymmdd(days)

    ; only process days after end of data in save file

    list = WHERE(new_days GT last_day, count)

    IF count EQ 0 THEN RETURN, 0

    days = days[list]

  ENDIF

  RETURN, 1

END
