;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_TEMPERATURE
;
; Purpose     :	Batch process IF files.
;
; Explanation : Batch process IF files.
;
; Use         : < rcs_batch_temperature, ids >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILES : STRARR containing IF file names for processing.
;
; Written     :	Version 0.0, 04/07/01
;
; Modified    : Version 0.1, 20/07/01
;                 Used rcs_sort_days.
;                 Used extended IF naming convention.
;                 Replaced keyword FILES with DAYS.
;                 Added keyword SC to argument list.
;               Version 0.2, 13/05/02
;                 Used rcs_to_yyyymmdd.
;                 Renamed routine from rcs_temperature.
;                 Used rcs_batch_setup_days.
;               Version 0.3, 12/02/03
;                 Added check that savefile defined.
;
; Version     :	Version  0.3, 12/02/03
;-
;**********************************************************

PRO rcs_batch_temperature, ids, sc, days, TEMP_PROCESS=temp_process

  COMMON rcs_temp_process_block, temps

  temps = 0

  last_time = 0.0d0

  ; check if savefile exists

  IF rcs_batch_check_savefile(sc,'temps.dat', save_file) THEN BEGIN

    RESTORE, save_file

    ; get last time processed

    IF KEYWORD_SET(temps) THEN last_time = temps[N_ELEMENTS(temps)-1].time

  ENDIF

  ; if savefile not defined then error

  IF NOT KEYWORD_SET(savefile) THEN BEGIN

    rcs_message, 'SAVEFILE ERROR', /CONTINUE
    RETURN

  ENDIF

  ; reset IF data (in case already data)

  ; get days for processing

  IF NOT rcs_batch_setup_days(sc, last_time, days) THEN RETURN

  ; loop through files

  ids = rcs_get_ids()

  ; if interactive then set hourglass

  IF KEYWORD_SET(ids) THEN IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

    rcs_text, 'TEMPERATURE PROCESSING '+days[k], /OVERRIDE

    ; reset IF data (in case already data)

    rcs_reset_if

    ; reprocess data

    rcs_temp_process_if, sc, days[k], TEMP_PROCESS=temp_process

    ; reset IF data

    rcs_reset_if

  ENDFOR

  IF NOT KEYWORD_SET(temps) THEN RETURN

  dir = rcs_get_ifdir(rcs_get_scname(sc))

  IF NOT KEYWORD_SET(dir) THEN RETURN

  SAVE, temps, FILE=save_file, /COMPRESS

  HELP, temps

  ; generate plots

  rcs_temperature_plot, sc, /PNG

END
