;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_concatenate
;
; Purpose     :	Concatenates IF data sets.
;
; Explanation : Concatenates IF data sets.
;               Also concatenates other structure arrays.
;
; Use         : < rcs_concatenate, output_header, output_data, input_header, input_data, /GROW
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : GROW : FLAG indicating should grow data array before filling
;
; Written     :	Version 0.0, 05/02/02
;
; Modified    : Version 0.1, 13/02/02
;                 Added GROW keyword.
;               Version 0.2, 27/02/03
;                 Allowed just data concatenation.
;
; Version     :	Version 0.2, 27/02/03
;-
;**********************************************************

PRO rcs_concatenate, output_header, output_data, input_header, input_data, GROW=grow

  IF KEYWORD_SET(output_data) THEN BEGIN

    ; NB if output_header not set then will still concatenate data

    ies_concatenate, HEADER=output_header, output_data, input_data, GROW=grow

  ENDIF ELSE BEGIN

    IF KEYWORD_SET(input_header) THEN output_header = input_header

    output_data = input_data

  ENDELSE

END
