;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_concatenate_if
;
; Purpose     :	Concatenates selected IF data sets.
;
; Explanation : Concatenates selected IF data sets.
;
; Use         : < rcs_concatenate_if
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text argument list and this argument list.
;               Version 0.3, 15/05/01
;                 Added CLEANBM2.
;               Version 0.4, 05/02/02
;                 Used rcs_concatenate.
;               Version 0.5, 08/02/02
;                 Added EPAD2.
;               Version 0.6, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.6, 08/10/03
;-
;**********************************************************

PRO rcs_concatenate_if

  ; global common blocks

  COMMON rcs_extract_block, tmax, data_reset

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; initialize restore variables

  input_header = 0

  input_data = 0

  ; get IF files

  files = ies_pickfile ( PATH=ies_get_dir('IF',/RAPID), COUNT=count, /MULTIPLE, $
                         TITLE='Select IF files for processing or CANCEL',/MUST_EXIST  )

  ; deal with CANCEL

  IF count EQ 0 THEN BEGIN
    rcs_text, 'No files selected for restoring'
    RETURN
  END

  ; sort files

  files = files[SORT(files)]

  ; loop through files

  FOR k = 0, count-1 DO BEGIN

    rcs_text, 'Restoring '+files[k]

    RESTORE, files[k]

    ; check exists

    IF KEYWORD_SET(input_header) AND KEYWORD_SET(input_data) THEN BEGIN

      ; sort out what IF data set it belongs to

      IF STRPOS(input_header.datatype,'IES_E3DDBM') GE 0 THEN BEGIN

        rcs_concatenate, e3ddbm_header, e3ddbm_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EHIST') GE 0 THEN BEGIN

        rcs_concatenate, ehist_header, ehist_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_E3DD') GE 0 THEN BEGIN

        rcs_concatenate, e3ddnm_header, e3ddnm_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EPAD2') GE 0 THEN BEGIN

        rcs_concatenate, epad2_header, epad2_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EPAD') GE 0 THEN BEGIN

        rcs_concatenate, epad_header, epad_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EHK') GE 0 THEN BEGIN

        rcs_concatenate, ehk_header, ehk_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEANBM') GE 0 THEN BEGIN

        rcs_concatenate, cleanbm_header, cleanbm_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEANBM2') GE 0 THEN BEGIN

        rcs_concatenate, cleanbm2_header, cleanbm2_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_ESPCT') GE 0 THEN BEGIN

        rcs_concatenate, espct_header, espct_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_PEDESTAL') GE 0 THEN BEGIN

        rcs_concatenate, pedestal_header, pedestal_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEAN') GE 0 THEN BEGIN

        rcs_concatenate, clean_header, clean_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_He') GE 0 THEN BEGIN

        rcs_concatenate, i3dd_header_He, i3dd_data_He, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_H') GE 0 THEN BEGIN

        rcs_concatenate, i3dd_header_H, i3dd_data_H, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_CNO') GE 0 THEN BEGIN

        rcs_concatenate, i3dd_header_CNO, i3dd_header_CNO, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_IPAD') GE 0 THEN BEGIN

        rcs_concatenate, ipad_header, ipad_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_HSPCT') GE 0 THEN BEGIN

        rcs_concatenate, hspct_header, hspct_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_ISPCT_He') GE 0 THEN BEGIN

        rcs_concatenate, ispct_header_He, ispct_data_He, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_ISPCT_CNO') GE 0 THEN BEGIN

        rcs_concatenate, ispct_header_CNO, ispct_data_CNO, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_MTRX') GE 0 THEN BEGIN

        rcs_concatenate, mtrx_header, mtrx_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGLBM') GE 0 THEN BEGIN

        rcs_concatenate, sglbm_header, sglbm_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL01') GE 0 THEN BEGIN

        rcs_concatenate, sgl01_header, sgl01_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL2') GE 0 THEN BEGIN

        rcs_concatenate, sgl2_header, sgl2_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL3') GE 0 THEN BEGIN

        rcs_concatenate, sgl3_header, sgl3_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'HK1') GE 0 THEN BEGIN

        rcs_concatenate, hk1_header, hk1_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'HK2') GE 0 THEN BEGIN

        rcs_concatenate, hk2_header, hk2_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'HK4') GE 0 THEN BEGIN

        rcs_concatenate, hk4_header, hk4_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'HK8') GE 0 THEN BEGIN

        rcs_concatenate, hk8_header, hk8_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'HK32') GE 0 THEN BEGIN

        rcs_concatenate, hk32_header, hk32_data, input_header, input_data

      ENDIF ELSE IF STRPOS(input_header.datatype,'SCINFO') GE 0 THEN BEGIN

        rcs_concatenate, scinfo_header, scinfo_data, input_header, input_data

      ENDIF ELSE BEGIN

        rcs_message, 'IF data set not recognized : '+input_header.datatype, /INFORMATIONAL

      ENDELSE

    ENDIF ELSE rcs_message,'NO INPUT DATA', /IMPLEMENTATION

  ENDFOR

  ; find tmax

  tmax = rcs_get_tmax()

END
