;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_COPY_CD
;
; Purpose     :	Copies files from CDROM to specified directory.
;
; Explanation : Copies files from CDROM to specified directory.
;
; Use         : < rcs_copy_cd >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 29/1/01
;
; Modified    : Version 0.1, 05/07/02
;                 Used new routine ies file exists
;               Version 0.2, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************

PRO rcs_copy_cd, sc, dir, NM=nm, BM=bm, HK=hk

  ; check S/C

  IF sc NE '1' AND sc NE '2' AND sc NE '3' AND sc NE '4' THEN BEGIN

    rcs_message, 'INVALID S/C SELECTION', /INFORMATIONAL

    RETURN

  ENDIF

  ; check if specified directory exists

  IF NOT rcs_dir_exist(dir) THEN BEGIN
    rcs_message, 'Specified directory does not exist : ' + dir, /INFORMATIONAL
    RETURN
  ENDIF

  ; create final sub-directories

  findirs = STRARR(3)

  findirs[0] = concat_dir(dir,'nsd_'+sc)

  IF NOT rcs_dir_exist(findirs[0],/CREATE) THEN BEGIN
    rcs_message, 'NSD sub-directory does not exist : ' + findirs[0], /INFORMATIONAL
    RETURN
  ENDIF

  findirs[1] = concat_dir(dir,'bsd_'+sc)

  IF NOT rcs_dir_exist(findirs[1],/CREATE) THEN BEGIN
    rcs_message, 'BSD sub-directory does not exist : ' + findirs[1], /INFORMATIONAL
    RETURN
  ENDIF

  findirs[2] = concat_dir(dir,'hkd_'+sc)

  IF NOT rcs_dir_exist(findirs[2],/CREATE) THEN BEGIN
    rcs_message, 'HKD sub-directory does not exist : ' + findirs[2], /INFORMATIONAL
    RETURN
  ENDIF

  ; test if root directory defined

  root = ies_get_dir('DATA',/RAPID)

  IF root EQ '' THEN BEGIN

    rcs_message, 'WARNING, NO CDROM DIRECTORY DEFINED', /INFORMATIONAL

    RETURN

  ENDIF

  ; get list of all sub-directories

  subdirs = rcs_find_subdirs(root)

  ; directory format is yymmdd_1_1a/CLUSTERn/NSD_n/yymmddRN.1An

  ; find all days

  list = INTARR(N_ELEMENTS(subdirs))

  FOR k = 0, N_ELEMENTS(subdirs)-1 DO IF STRLEN(strip_dirname(subdirs[k])) EQ 11 THEN list[k] = 1

  list = WHERE( list NE 0, count)

  IF count EQ 0 THEN BEGIN

    rcs_message, 'WARNING, NO VALID DAYS IN CDROM DIRECTORY', /INFORMATIONAL

    RETURN

  ENDIF

  subdirs = subdirs[list]

  ; sort list into day order

  subdirs = subdirs[SORT(subdirs)]

  ; deal with yy = 99

  list = WHERE(STRPOS(subdirs,'99') GE 0)

  IF list[0] GT 0 THEN subdirs = [subdirs[list[0]:*],subdirs[0:list[0]-1]]

  ; select CDROMs required

  list = rcs_list(subdirs, COUNT=count)

  IF count EQ 0 THEN BEGIN

    rcs_message, 'WARNING, NO SELECTION FROM CDROM DIRECTORY', /INFORMATIONAL

    RETURN

  ENDIF

  subdirs = subdirs[list]

  ; define types and doces

  types = ['NSD','BSD','HKD']

  codes = ['RN','RB','RH']

  ; loop through file streams adding file names

  streams = INDGEN(3)

  IF KEYWORD_SET(nm) THEN streams = [0]
  IF KEYWORD_SET(bm) THEN streams = [1]
  IF KEYWORD_SET(hk) THEN streams = [2]

  FOR n = 0, N_ELEMENTS(streams)-1 DO BEGIN

    ; get files

    files = ''

    FOR k = 0, count-1 DO BEGIN

      ; get subdirectory name

      subdir = strip_dirname(subdirs[k])

      ; get day

      day = STRMID(subdir,0,6)

      ; get CDROM no

      num = STRMID(subdir,7,1)

      ; get version

      ver = STRMID(subdir,10,1)

      ; get directory name

      dir = concat_dir(subdirs[k],'CLUSTER'+sc)

      dir = concat_dir(dir,types[streams[n]]+'_'+sc)

      file = concat_dir(dir,day+codes[streams[n]]+'.'+num+ver+sc)

      ; check file exists

      dummy = FINDFILE(file,COUNT=fcount)

      IF NOT ies_file_exists(file) THEN BEGIN

        PRINT, 'WARNING, FILE NOT FOUND : '+file

        file = STRLOWCASE(file)

      ENDIF

      IF NOT ies_file_exists(file) THEN BEGIN

        rcs_message, 'WARNING, NO FILE FOUND ON CDROM : '+file, /INFORMATIONAL

      ENDIF ELSE BEGIN

        ; copy file

        PRINT, 'Copying file : ' + file

        SPAWN, 'cp ' + file + ' ' + findirs[streams[n]]

      ENDELSE

    ENDFOR

  ENDFOR

END
