;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_INFO
;
; Purpose     :	Compound widget showing display description.
;
; Explanation : Allows user to set up display requirements.
;
; Use         : < id = rcs_cw_info(base) >
;
; Inputs      : base : LONG id of widget base.
;
; Opt. Inputs : None.
;
; Outputs     : id   : LONG id of widget top.
;
; Opt. Outputs: None.
;
; Keywords    : PARAMETERS : FLAG indicating parameters only
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 7/2/01
;                 Removed PRE and POST.
;                 Changed centroid to pedestal.
;                 Added ESPCT.
;               Version 0.2, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 25/05/01
;                 Added HKSUN and HKRAT.
;               Version 0.4, 31/05/01
;                 Added STABM and STOBM.
;               Version 0.5, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.5, 08/02/02
;-
;**********************************************************

PRO rcs_cw_info_event, event

  ; get widget IDs

  WIDGET_CONTROL, event.handler, GET_UVALUE=info_ids

  ; check for button events
  ; dont need to do anything with other events

  IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_BUTTON' THEN BEGIN

    WIDGET_CONTROL, event.id, GET_VALUE = value

    CASE value OF

      'BINS' : BEGIN

           WIDGET_CONTROL, event.id, SET_UVALUE=event.select

           WIDGET_CONTROL, info_ids.elog, GET_UVALUE=elog

           bins = event.select

           IF bins THEN BEGIN
             IF elog THEN WIDGET_CONTROL, info_ids.elo, SET_VALUE='0.5' $
               ELSE WIDGET_CONTROL, info_ids.elo, SET_VALUE='0'
             WIDGET_CONTROL, info_ids.ehi, SET_VALUE='12'
           ENDIF ELSE BEGIN
             IF elog THEN WIDGET_CONTROL, info_ids.elo, SET_VALUE='1' $
               ELSE WIDGET_CONTROL, info_ids.elo, SET_VALUE='0'
             WIDGET_CONTROL, info_ids.ehi, SET_VALUE='520'
           ENDELSE

         END

      'ELOG' : BEGIN

           WIDGET_CONTROL, event.id, SET_UVALUE=event.select

           WIDGET_CONTROL, info_ids.showch, GET_UVALUE=bins

           elog = event.select

           IF bins THEN BEGIN
             IF elog THEN WIDGET_CONTROL, info_ids.elo, SET_VALUE='0.5' $
               ELSE WIDGET_CONTROL, info_ids.elo, SET_VALUE='0'
             WIDGET_CONTROL, info_ids.ehi, SET_VALUE='12'
           ENDIF ELSE BEGIN
             IF elog THEN WIDGET_CONTROL, info_ids.elo, SET_VALUE='1' $
               ELSE WIDGET_CONTROL, info_ids.elo, SET_VALUE='0'
             WIDGET_CONTROL, info_ids.ehi, SET_VALUE='520'
           ENDELSE

         END

       ELSE  : WIDGET_CONTROL, event.id, SET_UVALUE=event.select ; for toggle buttons

     ENDCASE

  ENDIF

END

FUNCTION rcs_cw_info_getvalue, id

  ; NB does not return VALUEs but rather UVALUEs

  ; get widget IDs

  WIDGET_CONTROL, id, GET_UVALUE=info_ids

  ; set up output_info structure

  output_info = rcs_output_info()

  ; get values

  WIDGET_CONTROL, info_ids.title, GET_VALUE = value

  output_info.title = value[0]

  WIDGET_CONTROL, info_ids.elog, GET_UVALUE=uvalue

  output_info.elog = uvalue

  WIDGET_CONTROL, info_ids.log, GET_UVALUE=uvalue

  output_info.log = uvalue

  WIDGET_CONTROL, info_ids.nobad, GET_UVALUE=uvalue

  output_info.nobad = uvalue

  WIDGET_CONTROL, info_ids.showch, GET_UVALUE=uvalue

  output_info.showch = 1-uvalue

  WIDGET_CONTROL, info_ids.cal, GET_UVALUE=uvalue

  output_info.cal = uvalue

  WIDGET_CONTROL, info_ids.rat, GET_UVALUE=uvalue

  output_info.rat = uvalue

  WIDGET_CONTROL, info_ids.div, GET_UVALUE=uvalue

  output_info.div = uvalue

  WIDGET_CONTROL, info_ids.eff, GET_UVALUE=uvalue

  output_info.eff = uvalue

  WIDGET_CONTROL, info_ids.luts, GET_UVALUE=uvalue

  output_info.luts = uvalue

  WIDGET_CONTROL, info_ids.ehist, GET_UVALUE=uvalue

  output_info.ehist = uvalue

  WIDGET_CONTROL, info_ids.fit, GET_UVALUE=uvalue

  output_info.fit = 3*uvalue

  WIDGET_CONTROL, info_ids.scflag, GET_UVALUE=uvalue

  output_info.scflag = uvalue

  WIDGET_CONTROL, info_ids.hkflag, GET_UVALUE=uvalue

  output_info.hkflag = uvalue

  WIDGET_CONTROL, info_ids.tmp, GET_UVALUE=uvalue

  output_info.tmp = uvalue

  WIDGET_CONTROL, info_ids.hv, GET_UVALUE=uvalue

  output_info.hv = uvalue

  WIDGET_CONTROL, info_ids.hksun, GET_UVALUE=uvalue

  output_info.hksun = uvalue

  WIDGET_CONTROL, info_ids.hkrat, GET_UVALUE=uvalue

  output_info.hkrat = uvalue

  ; WIDGET_CONTROL, info_ids.m, GET_UVALUE=uvalue

  ; output_info.m = 2*uvalue

  WIDGET_CONTROL, info_ids.sectors, GET_UVALUE=uvalue

  output_info.sectors = uvalue

  WIDGET_CONTROL, info_ids.fulltime, GET_UVALUE=uvalue

  output_info.fulltime = uvalue

  WIDGET_CONTROL, info_ids.nohk, GET_UVALUE=uvalue

  output_info.nohk = uvalue

  FOR k = 0, N_ELEMENTS(output_info.use_ehk)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.hks[k], GET_UVALUE=uvalue

    output_info.use_ehk[k] = uvalue

  ENDFOR

  output_info.ehk = TOTAL(output_info.use_ehk)

  FOR k = 0, N_ELEMENTS(output_info.use_dets)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.e3dds[k], GET_UVALUE=uvalue

    output_info.use_dets[k] = uvalue

  ENDFOR

  output_info.e3dd = TOTAL(output_info.use_dets)

  FOR k = 0, N_ELEMENTS(output_info.use_bmdets)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.e3ddbms[k], GET_UVALUE=uvalue

    output_info.use_bmdets[k] = uvalue

  ENDFOR

  output_info.e3ddbm = TOTAL(output_info.use_bmdets)

  FOR k = 0, N_ELEMENTS(output_info.use_cleans)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.cleans[k], GET_UVALUE=uvalue

    output_info.use_cleans[k] = uvalue

  ENDFOR

  output_info.clean = TOTAL(output_info.use_cleans)

  FOR k = 0, N_ELEMENTS(output_info.use_bmcleans)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.cleanbms[k], GET_UVALUE=uvalue

    output_info.use_bmcleans[k] = uvalue

  ENDFOR

  output_info.cleanbm = TOTAL(output_info.use_bmcleans)

  FOR k = 0, N_ELEMENTS(output_info.use_bm2cleans)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.cleanbm2s[k], GET_UVALUE=uvalue

    output_info.use_bm2cleans[k] = uvalue

  ENDFOR

  output_info.cleanbm2 = TOTAL(output_info.use_bm2cleans)

  FOR k = 0, N_ELEMENTS(output_info.use_pedestals)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.pedestals[k], GET_UVALUE=uvalue

    output_info.use_pedestals[k] = uvalue

  ENDFOR

  output_info.pedestal = TOTAL(output_info.use_pedestals)

  FOR k = 0, N_ELEMENTS(output_info.use_epad)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.epads[k], GET_UVALUE=uvalue

    output_info.use_epad[k] = uvalue

  ENDFOR

  output_info.epad = TOTAL(output_info.use_epad)

  FOR k = 0, N_ELEMENTS(output_info.use_epad2)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.epad2s[k], GET_UVALUE=uvalue

    output_info.use_epad2[k] = uvalue

  ENDFOR

  output_info.epad2 = TOTAL(output_info.use_epad2)

  FOR k = 0, N_ELEMENTS(output_info.use_i3dd)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.i3dds[k], GET_UVALUE=uvalue

    output_info.use_i3dd[k] = uvalue

  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_i3ddm)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.i3ddms[k], GET_UVALUE=uvalue

    output_info.use_i3ddm[k] = uvalue

  ENDFOR

  output_info.i3dd = TOTAL(output_info.use_i3dd)*TOTAL(output_info.use_i3ddm)

  FOR k = 0, N_ELEMENTS(output_info.use_ipad)-1 DO BEGIN

    WIDGET_CONTROL, info_ids.ipads[k], GET_UVALUE=uvalue

    output_info.use_ipad[k] = uvalue

  ENDFOR

  output_info.ipad = TOTAL(output_info.use_ipad)

  WIDGET_CONTROL, info_ids.espct, GET_UVALUE=uvalue

  output_info.espct = uvalue

  WIDGET_CONTROL, info_ids.hspct, GET_UVALUE=uvalue

  output_info.hspct = uvalue

  WIDGET_CONTROL, info_ids.ispctHe, GET_UVALUE=uvalue

  output_info.ispctHe = uvalue

  WIDGET_CONTROL, info_ids.ispctCNO, GET_UVALUE=uvalue

  output_info.ispctCNO = uvalue

  WIDGET_CONTROL, info_ids.sglbm, GET_UVALUE=uvalue

  output_info.sglbm = uvalue*(1+2*output_info.sectors)

  WIDGET_CONTROL, info_ids.sgl01, GET_UVALUE=uvalue

  output_info.sgl01 = uvalue

  WIDGET_CONTROL, info_ids.sgl1, GET_UVALUE=uvalue

  output_info.sgl1 = uvalue

  WIDGET_CONTROL, info_ids.sgl2, GET_UVALUE=uvalue

  output_info.sgl2 = uvalue

  WIDGET_CONTROL, info_ids.sgl3, GET_UVALUE=uvalue

  output_info.sgl3 = uvalue

  WIDGET_CONTROL, info_ids.hist, GET_UVALUE=uvalue

  output_info.hist = uvalue

  WIDGET_CONTROL, info_ids.hkfcr, GET_UVALUE=uvalue

  output_info.hkfcr = uvalue

  WIDGET_CONTROL, info_ids.stabm, GET_UVALUE=uvalue

  output_info.stabm = uvalue

  WIDGET_CONTROL, info_ids.stobm, GET_UVALUE=uvalue

  output_info.stobm = uvalue

  WIDGET_CONTROL, info_ids.sta, GET_UVALUE=uvalue

  output_info.sta = uvalue

  WIDGET_CONTROL, info_ids.sto, GET_UVALUE=uvalue

  output_info.sto = uvalue

  WIDGET_CONTROL, info_ids.subc, GET_UVALUE=uvalue

  output_info.subc = uvalue

  WIDGET_CONTROL, info_ids.min, GET_VALUE=value

  output_info.minimum = FLOAT(value[0])

  WIDGET_CONTROL, info_ids.max, GET_VALUE=value

  output_info.maximum = FLOAT(value[0])

  WIDGET_CONTROL, info_ids.elo, GET_VALUE=value

  output_info.elow = FLOAT(value[0])

  WIDGET_CONTROL, info_ids.ehi, GET_VALUE=value

  output_info.ehigh = FLOAT(value[0])

  ; set ytitle

  IF KEYWORD_SET(output_info.showch) THEN output_info.ytitle = 'Energy [keV]' ELSE output_info.ytitle = 'Energy [channels]'

  ; set up no of output panels

  output_info.noutputs = output_info.e3dd + output_info.clean + output_info.e3ddbm + $
                         output_info.cleanbm + output_info.cleanbm2 + output_info.espct + output_info.ehist + $
                         output_info.luts + output_info.epad  + output_info.epad2 + output_info.ehk + $
                         output_info.scflag + output_info.hkflag + output_info.fit + $
                         output_info.i3dd + output_info.ipad + output_info.tmp + output_info.hspct + $
                         output_info.ispctHe + output_info.ispctCNO + output_info.sglbm + $
                         output_info.sgl01 + output_info.sgl1 + output_info.sgl2 + output_info.sgl3 + output_info.hv + $
                         output_info.hksun + output_info.hkrat + $
                         output_info.hkfcr + output_info.sta + output_info.sto + output_info.subc + $
                         output_info.stabm + output_info.stobm + $
                         output_info.pedestal + output_info.m

  RETURN, output_info

END

PRO rcs_cw_info_setvalue, id, output_info

  ; NB sets VALUEs not UVALUEs

  ; get widget IDs

  WIDGET_CONTROL, id, GET_UVALUE=info_ids

  ; set values

  WIDGET_CONTROL, info_ids.title, SET_VALUE=output_info.title

  WIDGET_CONTROL, info_ids.log, SET_UVALUE=output_info.log
  WIDGET_CONTROL, info_ids.log, SET_BUTTON=output_info.log

  WIDGET_CONTROL, info_ids.showch, SET_UVALUE=1-output_info.showch
  WIDGET_CONTROL, info_ids.showch, SET_BUTTON=1-output_info.showch

  WIDGET_CONTROL, info_ids.elog, SET_UVALUE=output_info.elog
  WIDGET_CONTROL, info_ids.elog, SET_BUTTON=output_info.elog

  WIDGET_CONTROL, info_ids.nobad, SET_UVALUE=output_info.nobad
  WIDGET_CONTROL, info_ids.nobad, SET_BUTTON=output_info.nobad

  WIDGET_CONTROL, info_ids.cal, SET_UVALUE=output_info.cal
  WIDGET_CONTROL, info_ids.cal, SET_BUTTON=output_info.cal

  WIDGET_CONTROL, info_ids.rat, SET_UVALUE=output_info.rat
  WIDGET_CONTROL, info_ids.rat, SET_BUTTON=output_info.rat

  WIDGET_CONTROL, info_ids.div, SET_UVALUE=output_info.div
  WIDGET_CONTROL, info_ids.div, SET_BUTTON=output_info.div

  WIDGET_CONTROL, info_ids.eff, SET_UVALUE=output_info.eff
  WIDGET_CONTROL, info_ids.eff, SET_BUTTON=output_info.eff

  WIDGET_CONTROL, info_ids.min, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.minimum)

  WIDGET_CONTROL, info_ids.max, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.maximum)

  WIDGET_CONTROL, info_ids.elo, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.elow)

  WIDGET_CONTROL, info_ids.ehi, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.ehigh)

  FOR k = 0, N_ELEMENTS(output_info.use_epad)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.epads[k], SET_UVALUE=output_info.use_epad[k]
    WIDGET_CONTROL, info_ids.epads[k], SET_BUTTON=output_info.use_epad[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_epad2)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.epad2s[k], SET_UVALUE=output_info.use_epad2[k]
    WIDGET_CONTROL, info_ids.epad2s[k], SET_BUTTON=output_info.use_epad2[k]
  ENDFOR

  WIDGET_CONTROL, info_ids.luts, SET_UVALUE=output_info.luts
  WIDGET_CONTROL, info_ids.luts, SET_BUTTON=output_info.luts

  WIDGET_CONTROL, info_ids.ehist, SET_UVALUE=output_info.ehist
  WIDGET_CONTROL, info_ids.ehist, SET_BUTTON=output_info.ehist

  WIDGET_CONTROL, info_ids.fit, SET_UVALUE=KEYWORD_SET(output_info.fit)
  WIDGET_CONTROL, info_ids.fit, SET_BUTTON=KEYWORD_SET(output_info.fit)

  WIDGET_CONTROL, info_ids.scflag, SET_UVALUE=output_info.scflag
  WIDGET_CONTROL, info_ids.scflag, SET_BUTTON=output_info.scflag

  WIDGET_CONTROL, info_ids.hkflag, SET_UVALUE=output_info.hkflag
  WIDGET_CONTROL, info_ids.hkflag, SET_BUTTON=output_info.hkflag

  WIDGET_CONTROL, info_ids.tmp, SET_UVALUE=output_info.tmp
  WIDGET_CONTROL, info_ids.tmp, SET_BUTTON=output_info.tmp

  WIDGET_CONTROL, info_ids.hv, SET_UVALUE=output_info.hv
  WIDGET_CONTROL, info_ids.hv, SET_BUTTON=output_info.hv

  WIDGET_CONTROL, info_ids.hksun, SET_UVALUE=output_info.hksun
  WIDGET_CONTROL, info_ids.hksun, SET_BUTTON=output_info.hksun

  WIDGET_CONTROL, info_ids.hkrat, SET_UVALUE=output_info.hkrat
  WIDGET_CONTROL, info_ids.hkrat, SET_BUTTON=output_info.hkrat

  WIDGET_CONTROL, info_ids.sectors, SET_UVALUE=output_info.sectors
  WIDGET_CONTROL, info_ids.sectors, SET_BUTTON=output_info.sectors

  WIDGET_CONTROL, info_ids.fulltime, SET_UVALUE=output_info.fulltime
  WIDGET_CONTROL, info_ids.fulltime, SET_BUTTON=output_info.fulltime

  WIDGET_CONTROL, info_ids.nohk, SET_UVALUE=output_info.nohk
  WIDGET_CONTROL, info_ids.nohk, SET_BUTTON=output_info.nohk

  ;WIDGET_CONTROL, info_ids.m, SET_UVALUE=KEYWORD_SET(output_info.m)
  ;WIDGET_CONTROL, info_ids.m, SET_BUTTON=KEYWORD_SET(output_info.m)

  FOR k = 0, N_ELEMENTS(output_info.use_ehk)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.hks[k], SET_UVALUE=output_info.use_ehk[k]
    WIDGET_CONTROL, info_ids.hks[k], SET_BUTTON=output_info.use_ehk[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_dets)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.e3dds[k], SET_UVALUE=output_info.use_dets[k]
    WIDGET_CONTROL, info_ids.e3dds[k], SET_BUTTON=output_info.use_dets[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_bmdets)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.e3ddbms[k], SET_UVALUE=output_info.use_bmdets[k]
    WIDGET_CONTROL, info_ids.e3ddbms[k], SET_BUTTON=output_info.use_bmdets[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_cleans)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.cleans[k], SET_UVALUE=output_info.use_cleans[k]
    WIDGET_CONTROL, info_ids.cleans[k], SET_BUTTON=output_info.use_cleans[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_bmcleans)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.cleanbms[k], SET_UVALUE=output_info.use_bmcleans[k]
    WIDGET_CONTROL, info_ids.cleanbms[k], SET_BUTTON=output_info.use_bmcleans[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_bm2cleans)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.cleanbm2s[k], SET_UVALUE=output_info.use_bm2cleans[k]
    WIDGET_CONTROL, info_ids.cleanbm2s[k], SET_BUTTON=output_info.use_bm2cleans[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_pedestals)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.pedestals[k], SET_UVALUE=output_info.use_pedestals[k]
    WIDGET_CONTROL, info_ids.pedestals[k], SET_BUTTON=output_info.use_pedestals[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_i3ddm)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.i3ddms[k], SET_UVALUE=output_info.use_i3ddm[k]
    WIDGET_CONTROL, info_ids.i3ddms[k], SET_BUTTON=output_info.use_i3ddm[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_ipad)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.ipads[k], SET_UVALUE=output_info.use_ipad[k]
    WIDGET_CONTROL, info_ids.ipads[k], SET_BUTTON=output_info.use_ipad[k]
  ENDFOR

  FOR k = 0, N_ELEMENTS(output_info.use_i3dd)-1 DO BEGIN
    WIDGET_CONTROL, info_ids.i3dds[k], SET_UVALUE=output_info.use_i3dd[k]
    WIDGET_CONTROL, info_ids.i3dds[k], SET_BUTTON=output_info.use_i3dd[k]
  ENDFOR

  WIDGET_CONTROL, info_ids.espct, SET_UVALUE=output_info.espct
  WIDGET_CONTROL, info_ids.espct, SET_BUTTON=output_info.espct

  WIDGET_CONTROL, info_ids.hspct, SET_UVALUE=output_info.hspct
  WIDGET_CONTROL, info_ids.hspct, SET_BUTTON=output_info.hspct

  WIDGET_CONTROL, info_ids.ispctHe, SET_UVALUE=output_info.ispctHe
  WIDGET_CONTROL, info_ids.ispctHe, SET_BUTTON=output_info.ispctHe

  WIDGET_CONTROL, info_ids.ispctCNO, SET_UVALUE=output_info.ispctCNO
  WIDGET_CONTROL, info_ids.ispctCNO, SET_BUTTON=output_info.ispctCNO

  WIDGET_CONTROL, info_ids.sglbm, SET_UVALUE=KEYWORD_SET(output_info.sglbm)
  WIDGET_CONTROL, info_ids.sglbm, SET_BUTTON=KEYWORD_SET(output_info.sglbm)

  WIDGET_CONTROL, info_ids.stabm, SET_UVALUE=output_info.stabm
  WIDGET_CONTROL, info_ids.stabm, SET_BUTTON=output_info.stabm

  WIDGET_CONTROL, info_ids.stobm, SET_UVALUE=output_info.stobm
  WIDGET_CONTROL, info_ids.stobm, SET_BUTTON=output_info.stobm

  WIDGET_CONTROL, info_ids.sgl01, SET_UVALUE=output_info.sgl01
  WIDGET_CONTROL, info_ids.sgl01, SET_BUTTON=output_info.sgl01

  WIDGET_CONTROL, info_ids.sgl1, SET_UVALUE=output_info.sgl1
  WIDGET_CONTROL, info_ids.sgl1, SET_BUTTON=output_info.sgl1

  WIDGET_CONTROL, info_ids.sgl2, SET_UVALUE=output_info.sgl2
  WIDGET_CONTROL, info_ids.sgl2, SET_BUTTON=output_info.sgl2

  WIDGET_CONTROL, info_ids.sgl3, SET_UVALUE=output_info.sgl3
  WIDGET_CONTROL, info_ids.sgl3, SET_BUTTON=output_info.sgl3

  WIDGET_CONTROL, info_ids.subc, SET_UVALUE=output_info.subc
  WIDGET_CONTROL, info_ids.subc, SET_BUTTON=output_info.subc

  WIDGET_CONTROL, info_ids.hkfcr, SET_UVALUE=output_info.hkfcr
  WIDGET_CONTROL, info_ids.hkfcr, SET_BUTTON=output_info.hkfcr

  WIDGET_CONTROL, info_ids.sta, SET_UVALUE=output_info.sta
  WIDGET_CONTROL, info_ids.sta, SET_BUTTON=output_info.sta

  WIDGET_CONTROL, info_ids.sto, SET_UVALUE=output_info.sto
  WIDGET_CONTROL, info_ids.sto, SET_BUTTON=output_info.sto

  WIDGET_CONTROL, info_ids.hist, SET_UVALUE=output_info.hist
  WIDGET_CONTROL, info_ids.hist, SET_BUTTON=output_info.hist

END

FUNCTION rcs_cw_info, base

  epad_names = ['Lo0', 'Lo1', 'Lo2', 'Hi0', 'Hi1', 'Hi2']

  ehk_names = 'Dt' + rcs_strtrim(INDGEN(9))

  e3dd_names = 'Dt' + rcs_strtrim(INDGEN(9))

  i3dd_names = 'Dt' + rcs_strtrim(INDGEN(12))

  i3ddm_names = ['H','He','CNO']

  ipad_names = ['Lo0', 'Lo1', 'Lo2', 'Hi0', 'Hi1', 'Hi2']

  ; set up info_ids to store widget_ids

  info_ids = {title:0L, log:0L, showch:0L, elog:0L, nobad:0L, cal:0L, rat:0L, div:0L, eff:0L, min:0L, max:0L, elo:0L, ehi:0L, $
              cleans:LONARR(9), cleanbms:LONARR(9), cleanbm2s:LONARR(9), pedestals:LONARR(9), m:0L, sectors:0L, fulltime:0L, nohk:0L, $
              epads:LONARR(6), epad2s:LONARR(6), luts:0L, ehist:0L, fit:0L, scflag:0L, hkflag:0L, tmp:0L, hv:0L, hksun:0L, hkrat:0L, $
              hks:LONARR(9), e3dds:LONARR(9), e3ddbms:LONARR(9), i3dds:LONARR(12), i3ddms:LONARR(3), ipads:LONARR(6), $
              espct:0L, hspct:0L, ispctHe:0L, ispctCNO:0L, sglbm:0L, stabm:0L, stobm:0L, sgl01:0L, sgl1:0L, sgl2:0L, sgl3:0L, hist:0L, hkfcr:0L, sta:0L, sto:0L, subc:0L}

  ; base id

  top = WIDGET_BASE(base, /COL, EVENT_PRO='rcs_cw_info_event', $
                    FUNC_GET_VALUE='rcs_cw_info_getvalue', PRO_SET_VALUE='rcs_cw_info_setvalue', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  dummy = WIDGET_LABEL(row, VALUE='TITLE')

  info_ids.title = WIDGET_TEXT(row, XSIZE=20, YSIZE=1, VALUE='', /EDITABLE, UVALUE='TITLE')

  ; set up fixed button labels
  ; use uvalues to store button values

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.log = WIDGET_BUTTON ( buttons, VALUE='LOG', UVALUE=0)

  info_ids.showch = WIDGET_BUTTON ( buttons, VALUE='BINS', UVALUE=0)

  info_ids.elog = WIDGET_BUTTON ( buttons, VALUE='ELOG', UVALUE=0)

  info_ids.nobad = WIDGET_BUTTON ( buttons, VALUE='NOBAD', UVALUE=0)

  info_ids.cal = WIDGET_BUTTON ( buttons, VALUE='CAL', UVALUE=0)

  info_ids.rat = WIDGET_BUTTON ( buttons, VALUE='RAT', UVALUE=0)

  info_ids.div = WIDGET_BUTTON ( buttons, VALUE='DIV', UVALUE=0)

  info_ids.eff = WIDGET_BUTTON ( buttons, VALUE='EFF', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  ; set max and min values to be non-adjustable ie +ve

  dummy  = WIDGET_BUTTON ( row, VALUE='MIN')

  info_ids.min = WIDGET_TEXT ( row, VALUE='', UVALUE='MINIMUM', /FRAME, XSIZE=9, /EDITABLE)

  dummy  = WIDGET_BUTTON ( row, VALUE='MAX')

  info_ids.max = WIDGET_TEXT ( row, VALUE='', UVALUE='MAXIMUM', /FRAME, XSIZE=9, /EDITABLE)

  ; set hi and lo values to be non-adjustable ie +ve

  dummy  = WIDGET_BUTTON ( row, VALUE='ELO')

  info_ids.elo = WIDGET_TEXT ( row, VALUE='', UVALUE='ELOW', /FRAME, XSIZE=9, /EDITABLE)

  dummy  = WIDGET_BUTTON ( row, VALUE='EHI')

  info_ids.ehi = WIDGET_TEXT ( row, VALUE='', UVALUE='EHIGH', /FRAME, XSIZE=9, /EDITABLE)

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.sectors = WIDGET_BUTTON ( buttons, VALUE='SECTORS', UVALUE=0)

  info_ids.fulltime = WIDGET_BUTTON ( buttons, VALUE='FULL TIME', UVALUE=0)

  info_ids.nohk = WIDGET_BUTTON ( buttons, VALUE='NO HK', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'IES ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.luts = WIDGET_BUTTON ( buttons, VALUE='LUTS', UVALUE=0)

  info_ids.ehist = WIDGET_BUTTON ( buttons, VALUE='E-HIST', UVALUE=0)

  info_ids.fit = WIDGET_BUTTON ( buttons, VALUE='FIT', UVALUE=0)

  info_ids.scflag = WIDGET_BUTTON ( buttons, VALUE='SC-FLAG', UVALUE=0)

  info_ids.subc = WIDGET_BUTTON ( buttons, VALUE='SUBC', UVALUE=0)

  info_ids.hist = WIDGET_BUTTON ( buttons, VALUE='HIST', UVALUE=0)

  info_ids.espct = WIDGET_BUTTON ( buttons, VALUE='ESPCT', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'E-PAD ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(epad_names)-1 DO info_ids.epads[k] = WIDGET_BUTTON ( buttons, VALUE=epad_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'E-PAD2 ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(epad_names)-1 DO info_ids.epad2s[k] = WIDGET_BUTTON ( buttons, VALUE=epad_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'E-3DD ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.e3dds[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'E-3DDBM ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.e3ddbms[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'CLEAN ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.cleans[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'CLEANBM ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.cleanbms[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'CLEANBM2 ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.cleanbm2s[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'PEDESTAL ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(e3dd_names)-1 DO info_ids.pedestals[k] = WIDGET_BUTTON ( buttons, VALUE=e3dd_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'HK ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  info_ids.hkflag = WIDGET_BUTTON ( buttons, VALUE='HK-FLAG', UVALUE=0)

  info_ids.tmp = WIDGET_BUTTON ( buttons, VALUE='TEMP', UVALUE=0)

  info_ids.hv = WIDGET_BUTTON ( buttons, VALUE='HV', UVALUE=0)

  info_ids.hkfcr = WIDGET_BUTTON ( buttons, VALUE='HKFCR', UVALUE=0)

  info_ids.hksun = WIDGET_BUTTON ( buttons, VALUE='HKSUN', UVALUE=0)

  info_ids.hkrat = WIDGET_BUTTON ( buttons, VALUE='HKRAT', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'E-HK ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(ehk_names)-1 DO  info_ids.hks[k] = WIDGET_BUTTON ( buttons, VALUE=ehk_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'IIMS ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.hspct = WIDGET_BUTTON ( buttons, VALUE='HSPCT', UVALUE=0)

  info_ids.ispctHe = WIDGET_BUTTON ( buttons, VALUE='ISPCT-He', UVALUE=0)

  info_ids.ispctCNO = WIDGET_BUTTON ( buttons, VALUE='ISPCT-CNO', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'SGL ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.sglbm = WIDGET_BUTTON ( buttons, VALUE='SGLBM', UVALUE=0)

  info_ids.stabm = WIDGET_BUTTON ( buttons, VALUE='STABM', UVALUE=0)

  info_ids.stobm = WIDGET_BUTTON ( buttons, VALUE='STOBM', UVALUE=0)

  info_ids.sgl01 = WIDGET_BUTTON ( buttons, VALUE='SGL0/1', UVALUE=0)

  info_ids.sgl1 = WIDGET_BUTTON ( buttons, VALUE='SGL1', UVALUE=0)

  info_ids.sgl2 = WIDGET_BUTTON ( buttons, VALUE='SGL2', UVALUE=0)

  info_ids.sgl3 = WIDGET_BUTTON ( buttons, VALUE='SGL3', UVALUE=0)

  info_ids.sta = WIDGET_BUTTON ( buttons, VALUE='STA', UVALUE=0)

  info_ids.sto = WIDGET_BUTTON ( buttons, VALUE='STO', UVALUE=0)

  ; info_ids.m = WIDGET_BUTTON ( buttons, VALUE='M', UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'I-PAD ' )

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(ipad_names)-1 DO info_ids.ipads[k] = WIDGET_BUTTON ( buttons, VALUE=ipad_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'M_CH ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(i3ddm_names)-1 DO info_ids.i3ddms[k] = WIDGET_BUTTON ( buttons, VALUE=i3ddm_names[k], UVALUE=0)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  label  = WIDGET_LABEL ( row, VALUE = 'I-3DD ' )

  buttons = WIDGET_BASE  ( row, /ROW, /NONEXCLUSIVE)

  FOR k = 0, N_ELEMENTS(i3dd_names)-1 DO info_ids.i3dds[k] = WIDGET_BUTTON ( buttons, VALUE=i3dd_names[k], UVALUE=0)

  ; set handler uvalue to widget IDs

  WIDGET_CONTROL, top, SET_UVALUE=info_ids

  RETURN, top

END
