;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_PARAMETERS
;
; Purpose     :	Compound widget for changing output_info parameters.
;
; Explanation : Compound widget for changing output_info parameters.
;
; Use         : < id = rcs_cw_info(base) >
;
; Inputs      : base : LONG id of widget base.
;
; Opt. Inputs : None.
;
; Outputs     : id   : LONG id of widget top.
;
; Opt. Outputs: None.
;
; Keywords    : PARAMETERS : FLAG indicating parameters only
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 7/2/01
;                 Added PARAMETERS keyword.
;               Version 0.2, 16/05/01
;                 Added UVALUEs for MIN,MAX,ELO,EHI buttons.
;
; Version     :	Version 0.2, 16/05/01
;-
;**********************************************************

PRO rcs_cw_parameters_event, event

  COMMON output_info_local, info_ids, output_info

  ; get event uvalue

  WIDGET_CONTROL, event.id, GET_UVALUE = uvalue

  CASE uvalue OF

    'LOG' : output_info.log = 1 - output_info.log

    'BINS' : output_info.showch = 1 - output_info.showch

    'ELOG' : output_info.elog = 1 - output_info.elog

    'NOBAD' : output_info.nobad = 1 - output_info.nobad

    'CAL' : output_info.cal = 1 - output_info.cal

    'RAT' : output_info.rat = 1 - output_info.rat

    'DIV' : output_info.div = 1 - output_info.div

    'EFF' : output_info.eff = 1 - output_info.eff

    'MIN' :

    'MAX' :

    'ELO' :

    'EHI' :

    'MINIMUM' : BEGIN

         WIDGET_CONTROL, info_ids.min, GET_VALUE=value

         output_info.minimum = FLOAT(value[0])

       END

    'MAXIMUM': BEGIN

         WIDGET_CONTROL, info_ids.max, GET_VALUE=value

         output_info.maximum = FLOAT(value[0])

       END

    'ELOW': BEGIN

         WIDGET_CONTROL, info_ids.elo, GET_VALUE=value

         output_info.elow = FLOAT(value[0])

       END

    'EHIGH': BEGIN

         WIDGET_CONTROL, info_ids.ehi, GET_VALUE=value

         output_info.ehigh = FLOAT(value[0])

       END

    'FULL TIME' : output_info.fulltime = 1 - output_info.fulltime

    'NO HK' : output_info.nohk = 1 - output_info.nohk

    'DONE' : BEGIN

         WIDGET_CONTROL, info_ids.min, GET_VALUE=value

         output_info.minimum = FLOAT(value[0])

         WIDGET_CONTROL, info_ids.max, GET_VALUE=value

         output_info.maximum = FLOAT(value[0])

         WIDGET_CONTROL, info_ids.elo, GET_VALUE=value

         output_info.elow = FLOAT(value[0])

         WIDGET_CONTROL, info_ids.ehi, GET_VALUE=value

         output_info.ehigh = FLOAT(value[0])

         WIDGET_CONTROL, event.top, /DESTROY

       END

     ELSE  : rcs_message, /IMPLEMENTATION

  ENDCASE

END

PRO rcs_cw_parameters, base, input_output_info

  COMMON output_info_local, info_ids, output_info

  ; set up output_info

  output_info = input_output_info

  ; set up info_ids to store widget_ids

  info_ids = {log:0L, showch:0L, elog:0L, nobad:0L, cal:0L, rat:0L, div:0L, eff:0L, $
              min:0L, max:0L, elo:0L, ehi:0L, fulltime:0L, nohk:0L}

  ; base id

  top = WIDGET_BASE(/COL, GROUP_LEADER=base, /MODAL)

  ; next row

  row = WIDGET_BASE(top, /ROW)

  ; set up fixed button labels

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.log = WIDGET_BUTTON ( buttons, VALUE='LOG',UVALUE='LOG')

  info_ids.showch = WIDGET_BUTTON ( buttons, VALUE='BINS', UVALUE='BINS')

  info_ids.elog = WIDGET_BUTTON ( buttons, VALUE='ELOG', UVALUE='ELOG')

  info_ids.nobad = WIDGET_BUTTON ( buttons, VALUE='NOBAD', UVALUE='NOBAD')

  info_ids.cal = WIDGET_BUTTON ( buttons, VALUE='CAL', UVALUE='CAL')

  info_ids.rat = WIDGET_BUTTON ( buttons, VALUE='RAT', UVALUE='RAT')

  info_ids.div = WIDGET_BUTTON ( buttons, VALUE='DIV', UVALUE='DIV')

  info_ids.eff = WIDGET_BUTTON ( buttons, VALUE='EFF', UVALUE='EFF')

  ; next row

  row = WIDGET_BASE(top, /ROW)

  ; set max and min values to be non-adjustable ie +ve

  dummy  = WIDGET_BUTTON ( row, VALUE='MIN', UVALUE='MIN')

  info_ids.min = WIDGET_TEXT ( row, VALUE='', UVALUE='MINIMUM', /FRAME, XSIZE=9, /EDITABLE)

  dummy  = WIDGET_BUTTON ( row, VALUE='MAX', UVALUE='MAX')

  info_ids.max = WIDGET_TEXT ( row, VALUE='', UVALUE='MAXIMUM', /FRAME, XSIZE=9, /EDITABLE)

  ; set hi and lo values to be non-adjustable ie +ve

  dummy  = WIDGET_BUTTON ( row, VALUE='ELO', UVALUE='ELO')

  info_ids.elo = WIDGET_TEXT ( row, VALUE='', UVALUE='ELOW', /FRAME, XSIZE=9, /EDITABLE)

  dummy  = WIDGET_BUTTON ( row, VALUE='EHI', UVALUE='EHI')

  info_ids.ehi = WIDGET_TEXT ( row, VALUE='', UVALUE='EHIGH', /FRAME, XSIZE=9, /EDITABLE)

  buttons = WIDGET_BASE(row, /ROW, /NONEXCLUSIVE)

  info_ids.fulltime = WIDGET_BUTTON ( buttons, VALUE='FULL TIME', UVALUE='FULL TIME')

  info_ids.nohk = WIDGET_BUTTON ( buttons, VALUE='NO HK', UVALUE='NO HK')

  ; next row

  row = WIDGET_BASE(top, /ROW)

  info_ids.eff = WIDGET_BUTTON ( row, VALUE='DONE', UVALUE='DONE')

  ; realize the widget

  WIDGET_CONTROL, top, /REALIZE

  ; set values

  WIDGET_CONTROL, info_ids.log, SET_BUTTON=output_info.log

  WIDGET_CONTROL, info_ids.showch, SET_BUTTON=1-output_info.showch

  WIDGET_CONTROL, info_ids.elog, SET_BUTTON=output_info.elog

  WIDGET_CONTROL, info_ids.nobad, SET_BUTTON=output_info.nobad

  WIDGET_CONTROL, info_ids.cal, SET_BUTTON=output_info.cal

  WIDGET_CONTROL, info_ids.rat, SET_BUTTON=output_info.rat

  WIDGET_CONTROL, info_ids.div, SET_BUTTON=output_info.div

  WIDGET_CONTROL, info_ids.eff, SET_BUTTON=output_info.eff

  WIDGET_CONTROL, info_ids.min, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.minimum)

  WIDGET_CONTROL, info_ids.max, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.maximum)

  WIDGET_CONTROL, info_ids.elo, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.elow)

  WIDGET_CONTROL, info_ids.ehi, SET_VALUE=rcs_strtrim(FORMAT='(G9.3)',output_info.ehigh)

  WIDGET_CONTROL, info_ids.fulltime, SET_BUTTON=output_info.fulltime

  WIDGET_CONTROL, info_ids.nohk, SET_BUTTON=output_info.nohk

  ; start processing events

  XMANAGER, 'rcs_cw_parameters', top

  ; set final output_info

  input_output_info = output_info

END
