;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_SHOWEDB
;
; Purpose     :	Launches RAPID COMMISSIONING SW EDB EXTRACTION WIDGET.
;
; Explanation : Sets up widget for RAPID data input,
;               NB Avoids use of common BLOCKs to facilitate possibility of multiple versions of this
;               widget running on different data files.
;               Allows input of either CDDS or GSEOS format data.
;               Default is CDDS data format.
;
; Use         : < rcs_in >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Added silent flag..
;               Version 0.2, 10/2/01
;                 Changed silent to common block.
;                 Changed to using common block to store edb_count.
;
; Version     :	Version 0.2, 10/2/01
;-
;**********************************************************

PRO rcs_cw_showedb_setvalue, id, values

  IF NOT KEYWORD_SET(values) THEN values = {nm:0L, bm1:0L, bm2:0L, bm3:0L, hk:0L}

  ; get widget IDs

  WIDGET_CONTROL, id, GET_UVALUE=ids

  WIDGET_CONTROL, ids.nm, SET_VALUE=rcs_strtrim(values.nm)

  WIDGET_CONTROL, ids.bm1, SET_VALUE=rcs_strtrim(values.bm1)

  WIDGET_CONTROL, ids.bm2, SET_VALUE=rcs_strtrim(values.bm2)

  WIDGET_CONTROL, ids.bm3, SET_VALUE=rcs_strtrim(values.bm3)

  WIDGET_CONTROL, ids.hk, SET_VALUE=rcs_strtrim(values.hk)

END

FUNCTION rcs_cw_showedb, base

  ; set up display box size

  xsize = 7

  ; set up stored ids

  ids = {nm:0L, bm1:0L, bm2:0L, bm3:0L, hk:0L}

  ; next row
  ; store ids in row uvalue

  row = WIDGET_BASE(base, /ROW, PRO_SET_VALUE='rcs_cw_showedb_setvalue', UVALUE=0)

  ; create widgets for output info

  dummy = WIDGET_LABEL(row, VALUE='NM EDBs')

  ids.nm = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='BM1 EDBs')

  ids.bm1 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='BM2 EDBs')

  ids.bm2 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='BM3 EDBs')

  ids.bm3 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='HK EBDs')

  ids.hk = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  ; set handler uvalue to widget IDs

  WIDGET_CONTROL, row, SET_UVALUE=ids

  RETURN, row

END

