;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_SHOWIF
;
; Purpose     :	Compound widget showing state of IF data set accumulation.
;
; Explanation : Shows how many samples for each IF data set.
;               Allows accumulation of individual or groups of IF data sets to be
;               switched on/off.
;
; Use         : < top = rcs_cw_showif(base, SENSITIVE=sensitive) >
;
; Inputs      : base : LONG widget ID of parent.
;
; Opt. Inputs : None.
;
; Outputs     : top : LONG widget ID of child.
;
; Opt. Outputs: None.
;
; Keywords    : SENSITIVE : Flag indicating whether buttons corresponding to text widgets can be toggled.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 6/2/01
;                 Add PEDESTAL and ESPCT IF data.
;               Version 0.2, 13/2/01
;                 Converted to using COMMON blocks for use.
;               Version 0.3, 5/3/01
;                 Changed display box size to 5.
;               Version 0.4, 9/3/01
;                 Put back in button for multiple IF sets.
;                 Allowed use sensitivities to be set.
;               Version 0.5, 15/05/01
;                 Added cleanbm2.
;                 Removed setting of sensitivities in update of use.
;               Version 0.6, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.6, 08/02/02
;-
;**********************************************************

PRO rcs_set_sensitivities, ids, use

  ; set sensitivities

  rcs_sensitive, ids.e3dd, use.e3dd

  rcs_sensitive, ids.clean, use.clean

  rcs_sensitive, ids.cleanbm, use.cleanbm

  rcs_sensitive, ids.cleanbm2, use.cleanbm2

  rcs_sensitive, ids.espct, use.espct

  rcs_sensitive, ids.pedestal, use.pedestal

  rcs_sensitive, ids.e3ddbm, use.e3ddbm

  rcs_sensitive, ids.epad, use.epad

  rcs_sensitive, ids.epad2, use.epad2

  rcs_sensitive, ids.ehist, use.ehist

  rcs_sensitive, ids.ehk, use.ehk

  rcs_sensitive, ids.i3dd, use.i3dd

  rcs_sensitive, ids.ipad, use.ipad

  rcs_sensitive, ids.ispct, use.ispct

  rcs_sensitive, ids.hspct, use.hspct

  rcs_sensitive, ids.mtrx, use.mtrx

  rcs_sensitive, ids.sglbm, use.sglbm

  rcs_sensitive, ids.sgl01, use.sgl01

  rcs_sensitive, ids.sgl2, use.sgl2

  rcs_sensitive, ids.sgl3, use.sgl3

  rcs_sensitive, ids.hk1, use.hk1

  rcs_sensitive, ids.hk2, use.hk2

  rcs_sensitive, ids.hk4, use.hk4

  rcs_sensitive, ids.hk8, use.hk8

  rcs_sensitive, ids.hk32, use.hk32

  rcs_sensitive, ids.scinfo, use.scinfo

END

PRO rcs_cw_showif_event, event

  ; get widget IDs

  WIDGET_CONTROL, event.handler, GET_UVALUE=ids

  ; get value

  WIDGET_CONTROL, event.id, GET_VALUE=value

  ; get current settings

  use = rcs_get_use()

  CASE value OF

   'E3DD' : use.e3dd = 1 - use.e3dd

   'E3DDBM' : use.e3ddbm = 1 - use.e3ddbm

   'CLEAN' : use.clean = 1 - use.clean

   'CLEANBM' : use.cleanbm = 1 - use.cleanbm

   'CLEANBM2' : use.cleanbm2 = 1 - use.cleanbm2

   'ESPCT' : use.espct = 1 - use.espct

   'PEDESTAL' : use.pedestal = 1 - use.pedestal

   'EPAD' : use.epad = 1 - use.epad

   'EPAD2' : use.epad2 = 1 - use.epad2

   'EHIST' : use.ehist = 1 - use.ehist

   'EHK' : use.ehk = 1 - use.ehk

   'HK1' : use.hk1 = 1 - use.hk1

   'HK2' : use.hk2 = 1 - use.hk2

   'HK4' : use.hk4 = 1 -use.hk4

   'HK8' : use.hk8 = 1 - use.hk8

   'HK32' : use.hk32 = 1 - use.hk32

   'I3DD' : use.i3dd = 1 - use.i3dd

   'IPAD' : use.ipad = 1 - use.ipad

   'ISPCT' : use.ispct = 1 - use.ispct

   'HSPCT' : use.hspct = 1 - use.hspct

   'MTRX' : use.mtrx = 1 - use.mtrx

   'SGLBM' : use.sglbm = 1 - use.sglbm

   'SGL01' : use.sgl01 = 1 - use.sgl01

   'SGL2' : use.sgl2 = 1 - use.sgl2

   'SGL3' : use.sgl3 = 1 - use.sgl3

   'SCINFO' : use.scinfo = 1 - use.scinfo

   'IES' : BEGIN

              use.e3dd = 1 - use.e3dd

              use.e3ddbm = use.e3dd

              use.epad = use.e3dd

              use.epad2 = use.e3dd

              use.ehist = use.e3dd

            END

   'IES2' : BEGIN

              use.clean = 1 - use.clean

              use.cleanbm = use.clean

              use.cleanbm2 = use.clean

              use.espct = use.clean

              use.pedestal = use.clean

            END

   'IIMS' : BEGIN

              use.i3dd = 1 - use.i3dd

              use.ipad = use.i3dd

              use.ispct = use.i3dd

              use.hspct = use.i3dd

            END

   'IIMS2' : BEGIN

              use.mtrx = 1 - use.mtrx

              use.sglbm = use.mtrx

              use.sgl01 = use.mtrx

              use.sgl2 = use.mtrx

              use.sgl3 = use.mtrx

            END

   'HK' : BEGIN

              use.ehk = 1 - use.ehk

              use.hk1 = use.ehk

              use.hk2 = use.ehk

              use.hk4 = use.ehk

              use.hk8 = use.ehk

              use.hk32 = use.ehk

            END

  ENDCASE

  ; set use value

  rcs_set_use, use

END

; This routine sets the current no of samples in each of the IF data sets or
; the sensitivities of the text widgets in accordance with use.

PRO rcs_cw_showif_setvalue, id, values

  ; NB sets no of IF samples
  ; get widget IDs

  WIDGET_CONTROL, id, GET_UVALUE=ids

  ; check if use settings

  IF N_TAGS(values) EQ 0 THEN BEGIN

    ; set use values

    rcs_set_sensitivities, ids, rcs_get_use()

    RETURN

  ENDIF

  ; check if only HK

  IF N_TAGS(values) EQ 7 THEN BEGIN

    WIDGET_CONTROL, ids.ehk, SET_VALUE=rcs_strtrim(values.ehk)

    WIDGET_CONTROL, ids.hk1, SET_VALUE=rcs_strtrim(values.hk1)

    WIDGET_CONTROL, ids.hk2, SET_VALUE=rcs_strtrim(values.hk2)

    WIDGET_CONTROL, ids.hk4, SET_VALUE=rcs_strtrim(values.hk4)

    WIDGET_CONTROL, ids.hk8, SET_VALUE=rcs_strtrim(values.hk8)

    WIDGET_CONTROL, ids.hk32, SET_VALUE=rcs_strtrim(values.hk32)

    WIDGET_CONTROL, ids.time, SET_VALUE=values.time

    RETURN

  ENDIF

  WIDGET_CONTROL, ids.e3dd, SET_VALUE=rcs_strtrim(values.e3dd)

  WIDGET_CONTROL, ids.clean, SET_VALUE=rcs_strtrim(values.clean)

  WIDGET_CONTROL, ids.cleanbm, SET_VALUE=rcs_strtrim(values.cleanbm)

  WIDGET_CONTROL, ids.cleanbm2, SET_VALUE=rcs_strtrim(values.cleanbm2)

  WIDGET_CONTROL, ids.espct, SET_VALUE=rcs_strtrim(values.espct)

  WIDGET_CONTROL, ids.pedestal, SET_VALUE=rcs_strtrim(values.pedestal)

  WIDGET_CONTROL, ids.ehist, SET_VALUE=rcs_strtrim(values.ehist)

  WIDGET_CONTROL, ids.e3ddbm, SET_VALUE=rcs_strtrim(values.e3ddbm)

  WIDGET_CONTROL, ids.epad, SET_VALUE=rcs_strtrim(values.epad)

  WIDGET_CONTROL, ids.epad2, SET_VALUE=rcs_strtrim(values.epad2)

  WIDGET_CONTROL, ids.ehk, SET_VALUE=rcs_strtrim(values.ehk)

  WIDGET_CONTROL, ids.i3dd, SET_VALUE=rcs_strtrim(values.i3dd)

  WIDGET_CONTROL, ids.ipad, SET_VALUE=rcs_strtrim(values.ipad)

  WIDGET_CONTROL, ids.ispct, SET_VALUE=rcs_strtrim(values.ispct)

  WIDGET_CONTROL, ids.hspct, SET_VALUE=rcs_strtrim(values.hspct)

  WIDGET_CONTROL, ids.mtrx, SET_VALUE=rcs_strtrim(values.mtrx)

  WIDGET_CONTROL, ids.sglbm, SET_VALUE=rcs_strtrim(values.sglbm)

  WIDGET_CONTROL, ids.sgl01, SET_VALUE=rcs_strtrim(values.sgl01)

  WIDGET_CONTROL, ids.sgl2, SET_VALUE=rcs_strtrim(values.sgl2)

  WIDGET_CONTROL, ids.sgl3, SET_VALUE=rcs_strtrim(values.sgl3)

  WIDGET_CONTROL, ids.hk1, SET_VALUE=rcs_strtrim(values.hk1)

  WIDGET_CONTROL, ids.hk2, SET_VALUE=rcs_strtrim(values.hk2)

  WIDGET_CONTROL, ids.hk4, SET_VALUE=rcs_strtrim(values.hk4)

  WIDGET_CONTROL, ids.hk8, SET_VALUE=rcs_strtrim(values.hk8)

  WIDGET_CONTROL, ids.hk32, SET_VALUE=rcs_strtrim(values.hk32)

  WIDGET_CONTROL, ids.scinfo, SET_VALUE=rcs_strtrim(values.scinfo)

  WIDGET_CONTROL, ids.time, SET_VALUE=values.time

  WIDGET_CONTROL, ids.instrument, SET_VALUE=values.instrument

  WIDGET_CONTROL, ids.ifsize, SET_VALUE=rcs_strtrim(values.ifsize)

END

FUNCTION rcs_cw_showif, base

  ; get default settings

  use = rcs_get_use()

  ; set up display box size

  xsize = 5

  ; set up stored ids

  ids = {e3dd:0L, clean:0L, e3ddbm:0L, cleanbm:0L, cleanbm2:0L, espct:0L, pedestal:0L, ehist:0L, ehk:0L, epad:0L, epad2:0L, i3dd:0L, ipad:0L, ispct:0L, hspct:0L, mtrx:0L, $
         sglbm:0L, sgl01:0L, sgl2:0L, sgl3:0L, hk1:0L, hk2:0L, hk4:0L, hk8:0L, hk32:0L, scinfo:0L, time:0L, instrument:0L, ifsize:0L}

  ; next row

  top = WIDGET_BASE(base, /COL, EVENT_PRO='rcs_cw_showif_event', $
                    FUNC_GET_VALUE='rcs_cw_showif_getvalue', PRO_SET_VALUE='rcs_cw_showif_setvalue', UVALUE=0)

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_LABEL(row, VALUE='TIME')

  ids.time = WIDGET_TEXT(row, XSIZE=20, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='S/C')

  ids.instrument = WIDGET_TEXT(row, XSIZE=15, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='IF bytes')

  ids.ifsize = WIDGET_TEXT(row, XSIZE=10, YSIZE=1, VALUE='')

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_BUTTON(row, VALUE='IES', /FRAME)

  e3dd_id = WIDGET_BUTTON(row, VALUE='E3DD')

  ids.e3dd = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  e3ddbm_id = WIDGET_BUTTON(row, VALUE='E3DDBM')

  ids.e3ddbm = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  epad_id = WIDGET_BUTTON(row, VALUE='EPAD')

  ids.epad = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  epad2_id = WIDGET_BUTTON(row, VALUE='EPAD2')

  ids.epad2 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  ehist_id = WIDGET_BUTTON(row, VALUE='EHIST')

  ids.ehist = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_BUTTON(row, VALUE='IES2', /FRAME)

  clean_id = WIDGET_BUTTON(row, VALUE='CLEAN')

  ids.clean = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  cleanbm_id = WIDGET_BUTTON(row, VALUE='CLEANBM')

  ids.cleanbm = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  cleanbm2_id = WIDGET_BUTTON(row, VALUE='CLEANBM2')

  ids.cleanbm2 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  espct_id = WIDGET_BUTTON(row, VALUE='ESPCT')

  ids.espct = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  pedestal_id = WIDGET_BUTTON(row, VALUE='PEDESTAL')

  ids.pedestal = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_BUTTON(row, VALUE='IIMS', /FRAME)

  i3dd_id = WIDGET_BUTTON(row, VALUE='I3DD')

  ids.i3dd = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  ipad_id = WIDGET_BUTTON(row, VALUE='IPAD')

  ids.ipad = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  ispct_id = WIDGET_BUTTON(row, VALUE='ISPCT')

  ids.ispct = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hspct_id = WIDGET_BUTTON(row, VALUE='HSPCT')

  ids.hspct = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  dummy = WIDGET_LABEL(row, VALUE='                ')

  scinfo_id = WIDGET_BUTTON(row, VALUE='SCINFO')

  ids.scinfo = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_BUTTON(row, VALUE='IIMS2', /FRAME)

  mtrx_id = WIDGET_BUTTON(row, VALUE='MTRX')

  ids.mtrx = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  sglbm_id = WIDGET_BUTTON(row, VALUE='SGLBM')

  ids.sglbm = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  sgl01_id = WIDGET_BUTTON(row, VALUE='SGL01')

  ids.sgl01 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  sgl2_id = WIDGET_BUTTON(row, VALUE='SGL2')

  ids.sgl2 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  sgl3_id = WIDGET_BUTTON(row, VALUE='SGL3')

  ids.sgl3 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  row = WIDGET_BASE(top,/ROW)

  dummy = WIDGET_BUTTON(row, VALUE='HK', /FRAME)

  ehk_id = WIDGET_BUTTON(row, VALUE='EHK')

  ids.ehk = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hk1_id = WIDGET_BUTTON(row, VALUE='HK1')

  ids.hk1 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hk2_id = WIDGET_BUTTON(row, VALUE='HK2')

  ids.hk2 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hk4_id = WIDGET_BUTTON(row, VALUE='HK4')

  ids.hk4 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hk8_id = WIDGET_BUTTON(row, VALUE='HK8')

  ids.hk8 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  hk32_id = WIDGET_BUTTON(row, VALUE='HK32')

  ids.hk32 = WIDGET_TEXT(row, XSIZE=xsize, YSIZE=1, VALUE='')

  ; set initial sensitivities of text widgets

  rcs_set_sensitivities, ids, use

  ; set handler uvalue to widget IDs

  WIDGET_CONTROL, top, SET_UVALUE=ids

  RETURN, top

END
