;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_SLIDER
;
; Purpose     :	Compound widget selecting start and end bins.
;
; Explanation : Compound widget selecting start and end bins.
;
; Use         : < bins = rcs_cw_slider(base,output_info) >
;
; Inputs      : base : LONG id of widget base.
;               output_info : STRUCTURE giving display info
;
; Opt. Inputs : None.
;
; Outputs     : bins  : FLTARR(2) start and end bins
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 25/1/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 25/1/01
;-
;**********************************************************

PRO rcs_cw_slider_event, event

  COMMON rcs_cw_slider_local, stbin, enbin

  ; get ids

  WIDGET_CONTROL, event.top, GET_UVALUE=ids

  ; get event uvalue

  WIDGET_CONTROL, event.id, GET_UVALUE = uvalue

  CASE uvalue OF

    'ST' : BEGIN

             stbin = event.value

             ; set slide end bin if changed

             WIDGET_CONTROL, ids.enbin, GET_VALUE = enbin

             IF ( event.value GT enbin ) THEN BEGIN
               WIDGET_CONTROL, ids.enbin, SET_VALUE = event.value
               enbin = event.value
             ENDIF

           END

    'EN'  : BEGIN

             enbin = event.value

             ; set slide start time if changed

             WIDGET_CONTROL, ids.stbin, GET_VALUE = stbin

             IF ( event.value LT stbin ) THEN BEGIN
               WIDGET_CONTROL, ids.stbin, SET_VALUE = event.value
               stbin = event.value
             ENDIF

            END

    'DONE' : BEGIN

         WIDGET_CONTROL, ids.stbin, GET_VALUE = stbin

         WIDGET_CONTROL, ids.enbin, GET_VALUE = enbin

         WIDGET_CONTROL, event.top, /DESTROY

       END

  ENDCASE

END

FUNCTION rcs_cw_slider, base, output_info

  ; use COMMON block to pass info around
  ; NB can get away with this because is modal

  COMMON rcs_cw_slider_local, stbin, enbin

  ; get limits

  bmin = 0

  bmax = 256

  stbin = output_info.elow

  enbin = output_info.ehigh

  ; set up variable for widget ids

  ids = {base:base, stbin:0L, enbin:0L}

  ; base id
  ; use UVALUE to store widget ids of start and end widgets

  top = WIDGET_BASE(/COL, TITLE='SELECT BIN RANGE', UVALUE=0, /MODAL, GROUP_LEADER=base)

  ; set sliders

  ids.stbin = WIDGET_SLIDER ( top, $
                               MINIMUM = bmin, $
                               MAXIMUM = bmax, $
                               TITLE   = 'Start Bin', $
                               UVALUE  = 'ST',$
                               XSIZE   = 248)

  ids.enbin = WIDGET_SLIDER ( top, $
                               MINIMUM = bmin, $
                               MAXIMUM = bmax, $
                               TITLE   = 'End Bin', $
                               UVALUE  = 'EN',$
                               XSIZE   = 248)


  dummy = WIDGET_BUTTON ( top, VALUE='DONE', UVALUE='DONE')

  ; realize the widget

  WIDGET_CONTROL, top, /REALIZE

  ; save widget ids

  WIDGET_CONTROL, top, SET_UVALUE = ids

  ; set start and end

  WIDGET_CONTROL, ids.stbin, SET_VALUE=stbin

  WIDGET_CONTROL, ids.enbin, SET_VALUE=enbin

  ; start processing events

  XMANAGER, 'rcs_cw_slider', top

  RETURN, [stbin,enbin]

END
