;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CW_TSLIDER
;
; Purpose     :	Compound widget selecting start and end times.
;
; Explanation : Compound widget selecting start and end times.
;
; Use         : < times = rcs_cw_tslider(base, tstart, tstop, tmin, tmax) >
;
; Inputs      : base : LONG id of widget base.
;               tstart : DOUBLE TAI currently selected start time
;               tstop  : DOUBLE TAI currently selected stop  time
;               tmin   : DOUBLE TAI min time
;               tmax   : DOUBLE TAI max time
;
; Opt. Inputs : None.
;
; Outputs     : times   : DBLARR(2) start and end TAI times
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 5/3/01
;                 Passed times explicitly.
;
; Version     :	Version 0.1, 5/3/01
;-
;**********************************************************

PRO rcs_cw_tslider_event, event

  COMMON rcs_cw_tslider_local, sttime, entime

  ; get ids

  WIDGET_CONTROL, event.top, GET_UVALUE=ids

  ; get event uvalue

  WIDGET_CONTROL, event.id, GET_UVALUE = uvalue

  CASE uvalue OF

    'ST' : BEGIN

             sttime = event.value

             ; set slide end time if changed

             WIDGET_CONTROL, ids.entime, GET_VALUE = entime

             IF ( event.value GT entime ) THEN BEGIN
               WIDGET_CONTROL, ids.entime, SET_VALUE = event.value
               entime = event.value
             ENDIF

           END

    'EN'  : BEGIN

             entime = event.value

             ; set slide start time if changed

             WIDGET_CONTROL, ids.sttime, GET_VALUE = sttime

             IF ( event.value LT sttime ) THEN BEGIN
               WIDGET_CONTROL, ids.sttime, SET_VALUE = event.value
               sttime = event.value
             ENDIF

            END

    'DONE' : BEGIN

         WIDGET_CONTROL, ids.sttime, GET_VALUE = sttime

         WIDGET_CONTROL, ids.entime, GET_VALUE = entime

         WIDGET_CONTROL, event.top, /DESTROY

       END

  ENDCASE

END

FUNCTION rcs_cw_tslider, base, tstart, tstop, tmin, tmax

  ; use COMMON block to pass info around
  ; NB can get away with this because is modal

  COMMON rcs_cw_tslider_local, sttime, entime

  sttime = tstart

  entime = tstop

  ; set up variable for widget ids

  ids = {base:base, sttime:0L, entime:0L}

  ; base id
  ; use UVALUE to store widget ids of start and end widgets

  top = WIDGET_BASE(/COL, TITLE='SELECT TIME INTERVAL', UVALUE=0, /MODAL, GROUP_LEADER=base)

  ; top row

  row = WIDGET_BASE(top, /ROW)

  ; set time sliders

  col = WIDGET_BASE ( row, /COLUMN)

  label  = WIDGET_LABEL ( col, VALUE = 'START TIME : ' +  anytim2cal ( tmin, form=9)  )

  ids.sttime = ies_tslider  ( col, $
                                    MINIMUM = tmin, $
                                    MAXIMUM = tmax, $
                                    TITLE   = 'Start Time', $
                                    UVALUE  = 'ST',$
                                    XSIZE   = 248, $
                                    /EDIT)

  col = WIDGET_BASE ( row, /COLUMN)

  label  = WIDGET_LABEL ( col, VALUE = '    END   TIME : ' +  anytim2cal ( tmax, form=9 )  )

  ids.entime = ies_tslider  ( col, $
                                    MINIMUM = tmin, $
                                    MAXIMUM = tmax, $
                                    TITLE   = 'End Time', $
                                    UVALUE  = 'EN',$
                                    XSIZE   = 248, $
                                    /TOP, /EDIT)

  dummy = WIDGET_BUTTON ( top, VALUE='DONE', UVALUE='DONE')

  ; realize the widget

  WIDGET_CONTROL, top, /REALIZE

  ; save widget ids

  WIDGET_CONTROL, top, SET_UVALUE = ids

  ; set start and end

  WIDGET_CONTROL, ids.sttime, SET_VALUE=sttime

  WIDGET_CONTROL, ids.entime, SET_VALUE=entime

  ; start processing events

  XMANAGER, 'rcs_cw_tslider', top

  RETURN, [sttime,entime]

END
