function rcs_dir_exist, dirlist, CREATE=create
;
;+
;   Name: rcs_dir_exist
;
;   Purpose: check if elements of input list are existing directories
;
;   Input Parameters:
;      dirlist - string/string array of directories to check
;
;   Output:
;      function returns boolean (0 - not directory, 1-directory)
;
;   Calling Sequence:
;      dirs=dir_exist(dirlist)
;
;   History:
;      2-Aug-93 (SLF)
;      3-Sep-00 (MKC) Added Win32 OS and CREATE keyword
;      17/1/02 -- fixed up problem that does not differentiate between files and directories
;                 under Unix
;      14/02/03 -- Allowed directory names containing blanks in WIN32
;      20/10/03 -- Added some printout.
;      08/11/03 -- Added error check when creating directory for Windows and unix
;-

outarr=0
if n_elements(dirlist) gt 0 then outarr=intarr(n_elements(dirlist))

sdirlist=size(dirlist)
if sdirlist(sdirlist(0)+1) ne 7 then begin
   rcs_message,/info,'String or String array input required...'
endif else begin
   case strupcase(!version.os) of
      'VMS': begin
	     updir=strupcase(dirlist)
             for i=0,n_elements(dirlist)-1 do begin
	         testdir=str_replace(updir(i),'.DIR','') + '.DIR'
		 fil=findfile(testdir,count=dcount)
                 outarr(i)=dcount gt 0
             endfor
         endcase
      'WIN32' : begin
            for i=0,n_elements(dirlist)-1 do begin
               fil = findfile(dirlist(i),count=dcount)
               if dcount ne 1 then outarr(i) = 0 $
               else if strmid(fil(0),strlen(fil(0))-1,1) ne '\' then outarr(i) = 0 $
               else outarr(i)=1

               ; nb fil[0] = dirlist[i]+'\'

               if not outarr(i) AND KEYWORD_SET(create) then begin

                 ;NB enclose in double quotes to allow directory names containing blanks
                 rcs_message,'Creating directory : '+dirlist[i], /INFORMATIONAL

                 spawn, 'mkdir "' + dirlist[i] + '"', r, e

                 IF NOT KEYWORD_SET(e) THEN outarr(i) = 1 ELSE rcs_message, e, /INFORMATIONAL

               endif
            endfor
         endcase
      else: begin
            for i=0,n_elements(dirlist)-1 do begin

               directory = dirlist[i]

               ; force  '/' for directories
               ; if doesnt exist then prints : directory : No such file or directory
               ; if exists and is directory then prints : directory/
               ; if exists and is file then prints : directory

               spawn,['ls','-dp',directory],out,/noshell

               IF out[0] NE '' THEN BEGIN

                 IF STRMID(out[0],STRLEN(out[0])-1,1) EQ '/' THEN outarr[i] = 1

               ENDIF

               if not outarr(i) AND KEYWORD_SET(create) then begin

                 rcs_message,'Creating directory : '+directory, /INFORMATIONAL

                 spawn, 'mkdir ' + directory, r, e

                 IF NOT KEYWORD_SET(e) THEN outarr(i) = 1 ELSE rcs_message, e, /INFORMATIONAL

               endif
            endfor
         endcase
   endcase
endelse

if n_elements(outarr) eq 1 then outarr=outarr(0)

return,outarr

end
