;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_EVENT
;
; Purpose     :	Manages events from RCS process.
;
; Explanation : Deals with events from the RCS_IN widget and uses TIMER events to trigger data extraction
;               from input data file.
;
; Use         : < rcs_event, event >
;
; Inputs      : event : EVENT structure from RCS widget.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, MKC, RAL, 13/12/00
;                 Removed TIMER case.
;               Version 0.2, 26/2/01
;                 Added BROWSE.
;               Version 0.3, 14/03/01
;                 Added FORCE.
;               Version 0.4, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.4, 09/10/03
;-
;**********************************************************

PRO rcs_event, event

  ; get widget IDs

  ids = rcs_get_ids()

  WIDGET_CONTROL, event.id, GET_UVALUE = uvalue

  CASE uvalue OF

   'MENU' : IF rcs_menu(ids, event.value) THEN RETURN

   'S/C' :

   'SILENT' : rcs_silent, ids, event.select

   'FORCE' : rcs_set_force, event.select

   'SKIP' : BEGIN

              WIDGET_CONTROL, ids.skiptime, GET_UVALUE=uvalue

              WIDGET_CONTROL, ids.skiptime, SET_UVALUE=1-uvalue

            END

   'BROWSE' : BEGIN

       dirname = DIALOG_PICKFILE(/DIRECTORY,PATH=ies_get_dir('DATA',/RAPID))

       IF dirname NE '' THEN SETENV, 'RCS_DATA_DIRECTORY='+dirname

       WIDGET_CONTROL, ids.datadir, SET_VALUE=ies_get_dir('DATA',/RAPID)

     END

  ENDCASE

  ; display state after any command

  rcs_extract_state, ids

  rcs_in_state, ids

END
