;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	RCS_FILES
;
; Purpose     :	Writes output to files widget.
;
; Explanation : Sends output to files widget.
;               Action depends on silent flag :
;                  0 : writes output
;                  1 : silent
;
; Use         : < rcs_files, n, file, APPEND=append >
;
; Inputs      : file : STRING file for display.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : APPEND : FLAG indicating whether file appended to file list or new file list
;               NOTEXT : FLAG indicating that if non-text widget output then do not print.
;
; Written     :	Version 0.0, 2/3/01
;
; Modified    : Version 0.1, 9/3/01
;                 Changed printout.
;               Version 0.2, 13/03/01
;                 Changed use of silent flag.
;               Version 0.3, 14/03/01
;                 Changed so that produces some output even if silent in batch mode.
;                 Removed ids from rcs_text argument list.
;
; Version     :	Version 0.3, 14/03/01
;-
;**********************************************************

PRO rcs_files, n, file, APPEND=append, NOTEXT=notext

  ids = rcs_get_ids()

  IF WIDGET_INFO(ids.in[n].file,/VALID_ID) THEN BEGIN

    IF rcs_get_silent() THEN RETURN

    WIDGET_CONTROL, ids.in[n].file, SET_VALUE=file, APPEND=append

  ENDIF ELSE IF NOT KEYWORD_SET(notext) THEN BEGIN

    IF KEYWORD_SET(append) THEN BEGIN

      rcs_text, 'STREAM '+rcs_strtrim(n)+' '+file, /OVERRIDE

    ENDIF ELSE BEGIN

      IF file NE '' THEN rcs_text, 'STREAM '+rcs_strtrim(n)+' '+file, /OVERRIDE

    ENDELSE

  ENDIF

END
