;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_FIND_MP
;
; Purpose     :	Works out the magnetic field in the SC reference frame for the M values
;               and M signs over a spin.
;               The m-value is the polar direction of the perpendicular to the B-field
;               expressed as 0-15 with 0 along the SC spin_axis.
;               At 90 degrees to this is the direction closest to the B field direction.
;               The sense of this is determined from the M-sign.
;
; Use         : < RCS_FIND_M, s, b, mp >
;
; Inputs      : mvals : BYTARR containing the [8]BYTE m values determining the detectors
;                       for each sector, [2]BYTE msigns determining B-field parallel or 
;                       anti-parallel.
;
; Opt. Inputs : None.
;
; Outputs     : mag : [2]FLTARR giving magnetic field azimuth and polar angles.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 27/02/02
;
; Modified    :	;
; Version     :	Version 0.0, 27/02/02
;-
;**********************************************************

PRO rcs_find_mp, s, b, mp, RESET=reset

  COMMON rcs_find_mp_local, sx, sy

  ; find projection of B field onto sector plane

  IF NOT KEYWORD_SET(sx) OR KEYWORD_SET(reset) THEN BEGIN

    ; set up sector plane normal vectors

    ph = (0.5+s)*2*!PI/16

    ; set up sector plane normals for each sector

    sx = COS(ph+!PI/2)
    sy = SIN(ph+!PI/2)

  ENDIF

  bth = b[1]
  bph = b[0]

  bx = SIN(bth)*COS(bph)
  by = SIN(bth)*SIN(bph)
  bz = COS(bth)

  ; get component of B field in sector plane normal direction for each sector

  bsn = bx*sx + by*sy

  ; get projection of B field in sector plane for each sector

  bsx = bx - bsn*sx
  bsy = by - bsn*sy

  bsproj = SQRT(bsx^2+bsy^2)

  ; get polar angle in sector plane 0->2*pi
  ; if B perpendicular to sector plan then goes in m=0

  th = (ATAN(bsproj,bz) + 2*!PI) MOD (2*!PI)  

  ; translate into fractional m direction
  ; asssume 16 even divisions 
 
  mp = th/!PI*16
print,b*180/!pi
print,mp,format='(16f8.3)'

END

