;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_FIND_PARENT
;
; Purpose     :	Finds parent of specified file.
;
; Explanation : Finds parent of specified file.
;
; Use         : < parent = rcs_find_parent(file) >
;
; Inputs      : root : STRING name of file.
;
; Opt. Inputs : None.
;
; Outputs     : parent : STRING parent directory
;
; Opt. Outputs: None.
;
; Keywords    : None
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/05/02
;
; Modified    : 
;
; Version     :	Version 0.0, 20/05/02
;-
;**********************************************************

FUNCTION rcs_find_parent, file

  filename = strip_dirname(file)

  dirlen = STRLEN(file)-STRLEN(filename)

  IF dirlen GT 0 THEN RETURN, STRMID(file,0,dirlen) ELSE RETURN, ''

END
