;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_FIND_SUBDIRS
;
; Purpose     :	Finds sub-directories of specified directory.
;
; Explanation : Finds sub-directories of specified directory.
;               Previously used CDS routine find_all_dirs but
;               had problems with CDROM under IDL version 3.0.3.
;               NB on output removes trailing slashes from
;               sub-directory names
;
; Use         : < subdirs = rcs_find_subdirs(root) >
;
; Inputs      : root : STRING name of root directory.
;                      Can have trailing slash or not.
;
; Opt. Inputs : None.
;
; Outputs     : subdirs : STRARR[*] names of subdirectories.
;
; Opt. Outputs: None.
;
; Keywords    : None
;
; Written     :	Version 0.0, Martin Carter, RAL, 18/1/01
;
; Modified    : Version 0.1, 17/1/02
;                 Added comment about Unix sub-directories
;               Version 0.2, 20/06/02
;                 Found under WINDOWS 98 at least that root directory was being added
;                 in twice. Explicitly removed before adding.
;
; Version     :	Version 0.2, 20/06/02
;-
;**********************************************************

FUNCTION rcs_find_subdirs, root

  ; get all files and directories in specified directory
  ; no trailing slash on root for windows ?

  CASE STRUPCASE(!VERSION.OS) OF

    'WIN32' : BEGIN

         slash = '\'

         files = FINDFILE(concat_dir(root,'*'))

       END

    'VMS' : rcs_message,'VMS NOT CURRENTLY SUPPORTED'

    ELSE : BEGIN

        slash = '/'

        ; create '/' ending for directories

        SPAWN,['ls','-p',root],files,/noshell

      END

  ENDCASE

  IF files[0] EQ '' THEN RETURN, ''

  list = WHERE(STRMID(files,0,1,/REVERSE_OFFSET) EQ slash, count)

  IF count EQ 0 THEN RETURN, ''

  files = files[list]

  ; remove trailing slashes

  FOR k = 0, count-1 DO files[k] = STRMID(files[k],0,STRLEN(files[k])-1)

  ; add root directory name
  ; ensur eonly added once

  RETURN, concat_dir(root,strip_dirname(files))

END
