;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_YYMMDD
;
; Purpose     :	Gets day string in form yymmdd.
;
; Explanation : Gets day string in form yymmdd.
;
; Use         : < res = rcs_get_yymmdd(time) >
;
; Inputs      : time  : time 
;
; Opt. Inputs : None.
;
; Outputs     : res : STRING day in yymmdd format.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 15/02/02
;
; Modified    : 
;
; Version     :	Version 0.0, 15/02/02
;-
;**********************************************************

FUNCTION rcs_get_yymmdd, time

  ext = anytim2utc(time,/EXTERNAL)

  yy = STRMID(STRING(ext.year,FORMAT='(I4)'),2,2)

  mm = STRING(ext.month,FORMAT='(I2.2)')

  dd = STRING(ext.day,FORMAT='(I2.2)')

  RETURN, yy+mm+dd

END
