;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_GYRO_RADIUS
;
; Purpose     :	Returns gyroradius of particle in km.
;
; Explanation : Returns gyroradius of particle in km.
;
; Use         : < radius = rcs_gyro_radius(kinetic_energy, field_strength, Re=re, E=e, P=p) >
;
; Inputs      : kinetic_energy : FLOAT energy of particle in keV
;               field_strength : FLOAT field strength in nT
;
; Opt. Inputs : None.
;
; Outputs     : radius : FLOAT gyroradius of particle in km
;
; Opt. Outputs:	None.
;
; Keywords    : Re : caluculate gyroradius in units of earth radius
;               e  : do for electron
;               p  : do for proton
;
; Written     :	Version 0.0, 23/05/02
;
; Modified    : Version 0.1, 08/02/03
;                 Used ies_gyro_radius.
;
; Version     :	Version 0.1, 08/02/03
;-
;**********************************************************

FUNCTION rcs_gyro_radius, kinetic_energy, field_strength, Re=re, E=e, P=p

  RETURN, ies_gyro_radius(kinetic_energy, field_strength, Re=re, E=e, P=p)

END
