;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IFNAME_DATATYPE
;
; Purpose     :	Gets IF datatype from input data file name.
;
; Explanation : Gets IF day from input data file name.
;               Filename has form :  ../datatype/yymmdd*.dat
;
; Use         : < datetype= RCS_IF_DATATYPE( filename ) >
;
; Inputs      : filename : STRING name of raw data file
;
; Opt. Inputs : None.
;
; Outputs     : name : STRING IF datatype
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/03/02
;
; Modified    :	
;
; Version     :	Version 0.0, 12/03/02
;-
;**********************************************************

FUNCTION rcs_ifname_datatype, filename

  ; find parent directory

  IF STRPOS(filename, '/') GE 0 THEN slash = '/' ELSE slash = '\' 
   
  file = filename

  pos = STRPOS(file, slash,/REVERSE_SEARCH)

  IF pos GE 0 THEN file = STRMID(file,0,pos) ELSE RETURN, ''

  pos = STRPOS(file, slash,/REVERSE_SEARCH)

  IF pos GE 0 THEN RETURN, STRMID(file,pos+1,20) ELSE RETURN, file

END
