;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IFNAME_DAY
;
; Purpose     :	Gets IF day from input data file name in form yymmdd.
;
; Explanation : Gets IF day from input data file name in form yymmdd.
;
; Use         : < day= RCS_IF_DAY( filename ) >
;
; Inputs      : filename : STRARR names of IF data file
;
; Opt. Inputs : None.
;
; Outputs     : name : STRING IF day, yymmdd.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 2/3/01
;                 Allowed DAT filenames.
;               Version 0.2, 12/3/02
;                 Renamed rcs_chk_filename.
;                 Renamed this routine.
;
; Version     :	Version 0.2, 12/3/02
;-
;**********************************************************

FUNCTION rcs_ifname_day, filename

  name = strip_dirname(filename)

  RETURN, STRMID(name,0,6)

END
