;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IFNAME_SC
;
; Purpose     :	Gets SC from IF filename.
;
; Explanation : Gets SC from IF filename.
;
; Use         : < sc = rcs_ifname_sc(ifname) >
;
; Inputs      : ifname : STRING IF data set name
;
; Opt. Inputs : None.
;
; Outputs     : sc : STRING charatectr giving S/C
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 22/03/01
;
; Modified    : None.
;
; Version     :	Version 0.0, 22/03/01
;-
;**********************************************************

FUNCTION rcs_ifname_sc, ifname

  ; get directory containing if DATA set e.g apath = 'ifdata\RAPID_1\IES_ESPCT\'

  dummy = strip_dirname(ifname,PATH=apath)

  IF apath EQ '' THEN GOTO, error

  ; remove end slash

  apath = STRMID(apath,0,STRLEN(apath)-1)

  ; get directory above this e.g path = 'ifdata\RAPID_1\'

  dummy = strip_dirname(apath,PATH=path)

  IF path EQ '' THEN GOTO, error

  ; remove end slash

  path = STRMID(path,0,STRLEN(path)-1)

  ; get sc

  scname = strip_dirname(path)

  IF STRLEN(scname) NE 7 THEN GOTO, error

  sc = STRMID(scname,6,1)

  RETURN, sc

  error : rcs_message, 'INVALID IF NAME', /INFORMATIONAL

  RETURN, ''

END
