;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IFNAME_SOURCE
;
; Purpose     :	Gets IF source from IF filename.
;
; Explanation : Gets IF source from IF filename.
;               IF filename has the form yymmdd_sss_v_a_b.dat
;
; Use         : < vs= RCS_IFNAME_SOURCE( filename ) >
;
; Inputs      : filename : STRING name of raw data file
;
; Opt. Inputs : None.
;
; Outputs     : s : STRING character IF source
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/02/03
;
; Modified    : Version 0.1, 02/09/03
;                 Changed source IDs.

; Version     :	Version 0.1, 02/09/03
;-
;**********************************************************

FUNCTION rcs_ifname_source, filename

  name = strip_dirname(filename)

  s = STRMID(name, 7, 3)

  RETURN, s

END
