;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IFNAME_SW_VERSION
;
; Purpose     :	Gets IF sw version from IF filename.
;
; Explanation : Gets IF sw version from IF filename.
;               IF filename has the form yymmdd_sss_v_a_b.dat
;
; Use         : < vs= RCS_IFNAME_SW_VERSION( filename ) >
;
; Inputs      : filename : STRING name of raw data file
;
; Opt. Inputs : None.
;
; Outputs     : sw : STRING IF sw version
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/02/03
;
; Modified    : Version 0.1, 02/09/03
;                 New source IDs.
;
; Version     :	Version 0.1, 02/09/03
;-
;**********************************************************

FUNCTION rcs_ifname_sw_version, filename

  name = strip_dirname(filename)

  length = STRPOS(name,'.')-13

  IF length LE 0 THEN RETURN, ''

  RETURN, STRMID(name, 13, length)

END
