;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_INITIALIZE_COMMON
;
; Purpose     :	Initialize COMMON blocks.
;
; Explanation : Initialize COMMON blocks. Now using COMMONs instead of UVALUES.
;
; Use         : < rcs_initialize_common >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : VERSION : STRING sw version for IF searches.
;                         If not set then SW will only accept IF files with same SW version number
;                         as current SW.
;
; Written     :	Version 0.0, 11/2/01
;
; Modified    : Version 0.1, 21/2/01
;                 Renamed batch --> auto
;               Version 0.2, 14/03/01
;                 Added force.
;               Version 0.3, 22/04/01
;                 Changed name of COMMON block.
;                 Added erdifind qualifier.
;               Version 0.4, 12/07/01
;                 Added nplots.
;               Version 0.5, 23/07/01
;                 Added source.
;               Version 0.6, 09/04/02
;                 Added sw version.
;               Version 0.7, 28/11/02
;                 Changed so that loads current SW version as version.
;                 Previously set version to '*' which means if version changes then have
;                 to explicitly FORCE recreation of IF data sets.
;               Version 0.8, 13/02/03
;                 Added VERSION keyword.
;               Version 0.9, 15/12/03
;                 Added initialization of pedestal calibration info.
;               Version 1.0, 09/01/04
;                 Used ies sw version.
;               Version 1.1, 02/02/04
;                 Added /FORCE to setup pedestal calibration.
;
; Version     :	Version 1.1, 02/02/04
;-
;**********************************************************

PRO rcs_initialize_common, ids, VERSION=version

  ; set up common block

  COMMON rcs_hk_qualifier_block, current_lut_no, current_erdifind

  ; initialize common blocks

  current_lut_no = -1

  current_erdifind = -1

  rcs_set_silent, 0

  rcs_set_force, 0

  rcs_set_auto, 0

  rcs_set_start, 0

  IF ies_tag_exists(ids,'IN') THEN BEGIN

    FOR k = 0, N_ELEMENTS(ids.in)-1 DO BEGIN

      rcs_set_files, k, ''

      rcs_set_header, k, 0

    ENDFOR

  ENDIF

  rcs_set_use, 0

  rcs_set_info, 0

  rcs_set_nplots, 0

  rcs_set_source, ids.type

  ; set SW version used for IF searches

  IF NOT KEYWORD_SET(version) THEN version = ies_sw_version()

  rcs_set_sw_version, version

  ; reset calibration info for cross_correlation
  ; this does not need to be done here unless have rubbish in common block but as well to reset

  rcs_setup_pedestal_calibration, '1', /FORCE

END
