;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_LIST
;
; Purpose     :	Allows selection of multiple items from a list.
;
; Explanation : Allows selection of multiple items from a list.
;
; Use         : < list = rcs_list(items) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT no of items selected
;               TITLE : STRING title
;
; Written     :	Version 0.0, Martin Carter, RAL, 6/1/01
;
; Modified    : Version 0.1, 27/1/01
;                 Added version options.
;                 Added TITLE keyword.
;
; Version     :	Version 0.1, 27/1/01
;-
;**********************************************************

PRO rcs_list_event, event

  COMMON list_block, mode, list

  IF TAG_NAMES(event,/STRUCTURE_NAME) EQ 'WIDGET_LIST' THEN BEGIN

    CASE mode OF

      0 : BEGIN

            list = event.index

            WIDGET_CONTROL, event.top, /DESTROY

        END

      1 : list = WIDGET_INFO(event.id, /LIST_SELECT)

      2 : BEGIN

            list = INDGEN(WIDGET_INFO(event.id, /LIST_NUMBER))

            list = list[event.index:*]

        END

    ENDCASE

  ENDIF ELSE BEGIN

    WIDGET_CONTROL, event.top, /DESTROY

  ENDELSE

END

FUNCTION rcs_list, items, COUNT=count, TITLE=title, GROUP_LEADER=group_leader, SINGLE=single

  ; set up common block

  COMMON list_block, mode, list

  list = -1

  ; set up base

  IF KEYWORD_SET(group_leader) THEN $
    base = WIDGET_BASE(TITLE=title,/COL, /MODAL, GROUP_LEADER=group_leader) $
  ELSE $
    base = WIDGET_BASE(TITLE=title,/COL)

  ; set up widget

  IF N_ELEMENTS(items) GT 20 THEN y_scroll_size = 256

  IF KEYWORD_SET(single) THEN BEGIN

    mode = 0

    IF NOT KEYWORD_SET(title) THEN title = 'SELECT ITEM'

    scroll_base = WIDGET_BASE(base, /COL, /SCROLL, Y_SCROLL_SIZE=y_scroll_size)

    dummy = WIDGET_LIST(scroll_base, VALUE=items, XSIZE=MAX(STRLEN(items))>8, YSIZE=N_ELEMENTS(items))

  ENDIF ELSE IF rcs_version() THEN BEGIN

    mode = 1

    IF NOT KEYWORD_SET(title) THEN title = 'SELECT ITEMS'

    scroll_base = WIDGET_BASE(base, /COL, /SCROLL, Y_SCROLL_SIZE=y_scroll_size)

    dummy = WIDGET_LIST(scroll_base, VALUE=items, /MULTIPLE, XSIZE=MAX(STRLEN(items))>8,YSIZE=N_ELEMENTS(items))

  ENDIF ELSE BEGIN

    mode = 2

    IF NOT KEYWORD_SET(title) THEN title = 'SELECT EARLIEST ITEM'

    scroll_base = WIDGET_BASE(base, /COL, /SCROLL, X_SCROLL_SIZE=128, Y_SCROLL_SIZE=y_scroll_size)

    dummy = WIDGET_LIST(scroll_base, VALUE=items, XSIZE=MAX(STRLEN(items))>8,YSIZE=N_ELEMENTS(items))

  ENDELSE

  IF NOT KEYWORD_SET(single) THEN dummy = WIDGET_BUTTON(base, VALUE='DONE')

  ; realize the widget

  WIDGET_CONTROL, base, /REALIZE

  ; start processing events

  XMANAGER, 'rcs_list', base;, GROUP_LEADER=group_leader

  count = 0
  IF list[0] NE -1 THEN count = N_ELEMENTS(list)

  RETURN, list

END
