;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MACHINE
;
; Purpose     :	Sets up machine dependent parameters.
;
; Explanation : Found differences between various machines in drawing widget sizes,
;               base widget size and fonts needed.
;               These are controlled by various parameters returned by this routine.
;               Sets up sizes for a no. of draw panels without scroll bars displayed within a larger
;               base with y scroll bars.
;               Sets font depending on machine via system variable !machine.
;
; Use         : < res = rcs_machine( noutputs, FONT=font >
;
; Inputs      : noutputs : no. of draw panels required.
;
; Opt. Inputs : None.
;
; Outputs     : If NOT KEYWORD_SET FONT then returns
;               res  : Structure containing
;                         xsize : INT x size of the base containing panels
;                         ysize : INT y size of the base containing panels
;                         scr_xsize : INT x size of the displayed base containing panels
;                         scr_ysize : INT y size of the displayed base containing panels
;                         pxsize : INT x size of the individual draw panels.
;                         pysize : INT y size of the individual draw panels.
;                         rcs_xsize : INT x size of the control base widget.
;                         rcs_ysize : INT y size of the control base widget.
;
; Opt. Outputs:	If KEYWORD_SET FONT then sets up default font.
;
; Keywords    : FONT : sets up default font for windows.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : RAPID COMMISSIONING SOFTWARE.
;
; Prev. Hist. :	Adapted from ies_machine.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_machine, noutputs, FONT=font

  IF KEYWORD_SET(font) THEN BEGIN

    WIDGET_CONTROL, DEFAULT_FONT=!machine.font

    RETURN, 0

  ENDIF

  ; pxsize and pysize are panel x and y size
  ; xsize, ysize specify the width and height of the widget
  ; scr_xsize, scr_ysize specify the width and height of the view of the drawing widget
  ; to avoid the Xscroll bars need to leave sufficient space for the Yscroll bars

  pxsize = !machine.pxsize
  pysize = !machine.pysize
  xsize = pxsize
  ysize = noutputs*(pysize+3)
  scr_xsize = xsize
  scr_ysize = ysize < !machine.max_scr_ysize
  rcs_xsize = !machine.rcs_xsize
  rcs_ysize = !machine.rcs_ysize

  RETURN, {xsize:xsize, ysize:ysize, scr_xsize:scr_xsize, scr_ysize:scr_ysize, $
           pxsize:pxsize, pysize:pysize, rcs_xsize:rcs_xsize, rcs_ysize:rcs_ysize}

END
