;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MAG_BSC
;
; Purpose     :	Works out the magnetic field in the SC reference frame from the M values
;               and M signs.
;
; Use         : < mf = RCS_MAG_BSC(data) >
;
; Inputs      : data : STRUCTURE ARRAY[nsamples] containing data. Has an .mvals tag.where
;                      mvals : BYTARR containing the [8]BYTE m values determining the detectors for each sector,
;                              [2]BYTE msigns determining B-field parallel or anti-parallel.
;
; Opt. Inputs : None.
;
; Outputs     : mf : STRUCTURE ARRAY[nsamples] giving magnetic field in [azimuth,polar,strength] format in the SC reference frame.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	Adapted from ies add mf for consistency with use of magnetic field generated elsewhere.
;
; Written     :	Version 0.0, Martin Carter, RAL, 04/10/03
;
; Modified    :
;
; Version     :	Version 0.0, 04/10/03
;-
;**********************************************************

FUNCTION rcs_mag_bsc, data

  ; if no mvals then cannot create mf

  IF NOT ies_tag_exists(data[0],'MVALS') THEN RETURN, 0

  mf = REPLICATE({IEL_STRUCT_BSC_V0, TIME:0.d0, MF:[0.,0.,0.]},N_ELEMENTS(data))

  mf.time = data.time

  ; loop through each sample
  ; work out corresponding azimuth and polar angles

  FOR k = 0, N_ELEMENTS(data)-1 DO mf[k].mf[0:1] = rcs_mag_sc(data[k].mvals)

  ; add in dummy magnetic field strength

  mf.mf[2] = 1

  RETURN, mf

END
