;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_MCP_PROCESS_IF
;
; Purpose     :
;
; Explanation :
;
; Use         : < rcs_mcp_process_if, sc,  day, type >
;
; Inputs      : sc     : STRING character giving SC.
;               day    : STRING day
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 12/06/01
;
; Modified    : Version 0.1, 25/06/01
;                 Tried to be more selective in samples used.
;                 Added processing of sglbm data.
;               Version 0.2, 20/07/01
;                 Used ies_runs.
;                 Changed name argument for day
;               Version 0.3, 12/09/01
;                 Added processing of SGL3 data.
;               Version 0.4, 13/03/02
;                 Changed sc argument to sc_root in rcs_restore_ifdata.
;               Version 0.5, 04/01/03
;                 Changed rcs_time_average to FUNCTION.
;
; Version     :	Version 0.5, 04/01/03
;-
;**********************************************************

PRO rcs_mcp_process_if, sc, day, MCP_PROCESS=mcp_process

  COMMON rcs_mcp_process_block, mode0, mode1, mode2, mode3, mode4, mode5

  ; check processing options

  CASE mcp_process OF

   1: BEGIN

    ; process HK1 data

    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'HK1', day, hk1_header, hk1_data) THEN BEGIN

      ; check IF data new enough

      IF hk1_header.ndetectors LT 12 THEN RETURN

      ; HK1 :
      ; 'ERISTAHV','ERISTOHV','ERIDEFHV','ERDTRIGM','ERDIFIND','ERDIFCAL','ERDDEADT','ERDHKFCR'
      ; 'ERISTACB', 'ERISTOCB', 'ERIENYCB', ERDTMMOD

      ; get data for which START and STOP HV on and DEF off

      ; ensure monotonic times

      IF hk1_header.npoints LT 2 THEN RETURN

      list = WHERE((hk1_data[1:*].time - hk1_data.time) GT 0.0d0, count)

      IF count NE hk1_header.npoints-1 THEN BEGIN

        PRINT, 'WARNING, NON-MONOTONIC TIMES'

        hk1_data = hk1_data[[0,list+1]]

        hk1_header.npoints = count+1

      ENDIF

      IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IIMS_SGL01', day, sgl01_header, sgl01_data) THEN BEGIN

        stahv = INTERPOL(hk1_data.data[0,0], hk1_data.time, sgl01_data.time)

        stohv = INTERPOL(hk1_data.data[0,1], hk1_data.time, sgl01_data.time)

        defhv = INTERPOL(hk1_data.data[0,2], hk1_data.time, sgl01_data.time)

        list = WHERE((stahv GT 2.5) AND (stohv GT 2.5) AND (defhv LT 0.5) AND (sgl01_data.flag AND '70'XB) EQ 0, count)

        IF count GT 0 THEN BEGIN

          ; remove bad data

          time = sgl01_data[list].time

          data = REFORM(sgl01_data[list].data[0,3:6],4,1,count)

          ; set bit 0 = NM/BM and bit 1 = Serial/Parallel

          modes = FIX(hk1_data.data[0,11]) OR ISHFT(FIX(hk1_data.data[0,4]),1)

          ; get list of ends of runs of modes

          list = ies_runs(modes)

          ; loop through runs of each mode

          pos = 0

          FOR l = 0, N_ELEMENTS(list)-1 DO BEGIN

            ; get mode

            mode = modes[list[l]]

            IF rcs_time_average(hk1_data[pos].time, hk1_data[list[l]].time, time, data, atime, adata, PERIOD=3600, POINTS=points) THEN BEGIN

              ; insist on a substantial no. of points

              vlist = WHERE(points GT 10, vcount)

              IF vcount GT 0 THEN BEGIN

                new = REPLICATE({time:0.0d0,data:FLTARR(4)},vcount)

                new.time = atime[vlist]
                new.data = REFORM(adata[*,0,vlist],4,vcount)

                CASE mode OF
                  0 : IF KEYWORD_SET(mode0) THEN mode0 = [mode0,new] ELSE mode0 = new
                  1 : IF KEYWORD_SET(mode1) THEN mode1 = [mode1,new] ELSE mode1 = new
                  2 : IF KEYWORD_SET(mode2) THEN mode2 = [mode2,new] ELSE mode2 = new
                  3 : IF KEYWORD_SET(mode3) THEN mode3 = [mode3,new] ELSE mode3 = new
                  ELSE : rcs_message,/IMPLEMENTATION
                ENDCASE

              ENDIF

            ENDIF

            pos = list(l)+1

          ENDFOR

        ENDIF

      ENDIF

      IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IIMS_SGLBM', day, sglbm_header, sglbm_data) THEN BEGIN

        stahv = INTERPOL(hk1_data.data[0,0], hk1_data.time, sglbm_data.time)

        stohv = INTERPOL(hk1_data.data[0,1], hk1_data.time, sglbm_data.time)

        defhv = INTERPOL(hk1_data.data[0,2], hk1_data.time, sglbm_data.time)

        list = WHERE((stahv GT 2.5) AND (stohv GT 2.5) AND (defhv LT 0.5) AND (sglbm_data.flag AND '70'XB) EQ 0, count)

        IF count GT 0 THEN BEGIN

          ; remove bad data

          time = sglbm_data[list].time

          data = REFORM(TOTAL(sglbm_data[list].data[11:13,3:4],1),2,1,count)

          ; set bit 0 = Serial/Parallel

          modes = FIX(hk1_data.data[0,4])

          ; get list of ends of runs of modes

          list = ies_runs(modes)

          ; loop through runs of each mode

          pos = 0

          FOR l = 0, N_ELEMENTS(list)-1 DO BEGIN

            ; get mode

            mode = modes[list[l]]

            IF rcs_time_average( hk1_data[pos].time, hk1_data[list[l]].time, time, data, atime, adata, PERIOD=3600, POINTS=points) THEN BEGIN

              ; insist on a substantial no. of points

              vlist = WHERE(points GT 10, vcount)

              IF vcount GT 0 THEN BEGIN

                new = REPLICATE({time:0.0d0,data:FLTARR(2)},vcount)

                new.time = atime[vlist]
                new.data = REFORM(adata[*,0,vlist],2,vcount)

                CASE mode OF
                  0 : IF KEYWORD_SET(mode4) THEN mode4 = [mode4,new] ELSE mode4 = new
                  1 : IF KEYWORD_SET(mode5) THEN mode5 = [mode5,new] ELSE mode5 = new
                  ELSE : rcs_message,/IMPLEMENTATION
                ENDCASE

              ENDIF

            ENDIF

            pos = list(l)+1

          ENDFOR

        ENDIF

      ENDIF

    ENDIF

   END

  2 : BEGIN

    ; process HK1 data

    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'HK1', day, hk1_header, hk1_data) THEN BEGIN

      ; check IF data new enough

      IF hk1_header.ndetectors LT 12 THEN RETURN

      ; HK1 :
      ; 'ERISTAHV','ERISTOHV','ERIDEFHV','ERDTRIGM','ERDIFIND','ERDIFCAL','ERDDEADT','ERDHKFCR'
      ; 'ERISTACB', 'ERISTOCB', 'ERIENYCB', ERDTMMOD

      ; get data for which START and STOP HV on and DEF off

      ; ensure monotonic times

      IF hk1_header.npoints LT 2 THEN RETURN

      list = WHERE((hk1_data[1:*].time - hk1_data.time) GT 0.0d0, count)

      IF count NE hk1_header.npoints-1 THEN BEGIN

        PRINT, 'WARNING, NON-MONOTONIC TIMES'

        hk1_data = hk1_data[[0,list+1]]

        hk1_header.npoints = count+1

      ENDIF

      ; sgl3 :
      ;['OVF1','OVF2','OVF3','SDIR-S1','SDIR-S2','SDIR-S3'
      ; 'SDIR-3S','TAC-S1','TAC-S2','TAC-S3',
      ; 'TAC11','TAC12','TAC13','TAC14','TAC21','TAC22','TAC23','TAC24',$
      ;  'TAC31','TAC32','TAC33','TAC34']

      IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IIMS_SGL3', day, sgl3_header, sgl3_data) THEN BEGIN

        stahv = INTERPOL(hk1_data.data[0,0], hk1_data.time, sgl3_data.time)

        stohv = INTERPOL(hk1_data.data[0,1], hk1_data.time, sgl3_data.time)

        defhv = INTERPOL(hk1_data.data[0,2], hk1_data.time, sgl3_data.time)

        list = WHERE((stahv GT 2.5) AND (stohv GT 2.5) AND (defhv LT 0.5) AND (sgl3_data.flag AND '70'XB) EQ 0, count)

        IF count GT 0 THEN BEGIN

          ; remove bad data

          time = sgl3_data[list].time

          data = REFORM(sgl3_data[list].data[0,3:6],4,1,count)

          ; set bit 1 = Serial/Parallel

          modes = ISHFT(FIX(hk1_data.data[0,4]),1)

          ; get list of ends of runs of modes

          list = ies_runs(modes)

          ; loop through runs of each mode

          pos = 0

          FOR l = 0, N_ELEMENTS(list)-1 DO BEGIN

            ; get mode

            mode = modes[list[l]]

            IF rcs_time_average( hk1_data[pos].time, hk1_data[list[l]].time, time, data, atime, adata, PERIOD=3600, POINTS=points) THEN BEGIN

              ; insist on a substantial no. of points

              vlist = WHERE(points GT 10, vcount)

              IF vcount GT 0 THEN BEGIN

                new = REPLICATE({time:0.0d0,data:FLTARR(4)},vcount)

                new.time = atime[vlist]
                new.data = REFORM(adata[*,0,vlist],4,vcount)

                CASE mode OF
                  0 : IF KEYWORD_SET(mode0) THEN mode0 = [mode0,new] ELSE mode0 = new
                  2 : IF KEYWORD_SET(mode2) THEN mode2 = [mode2,new] ELSE mode2 = new
                  ELSE : rcs_message,/IMPLEMENTATION
                ENDCASE

              ENDIF

            ENDIF

            pos = list(l)+1

          ENDFOR

        ENDIF

      ENDIF

    ENDIF

   END

   ELSE : rcs_message,'MCP PROCESS TYPE NOT KNOWN',/INFORMATIONAL

  ENDCASE

END
