;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MENU
;
; Purpose     :	Manages events from RCS MENU droplist.
;
; Explanation : Manages events from RCS MENU droplist.
;
; Use         : < res = rcs_menu ( ids, value ) >
;
; Inputs      : ids   : STRUCTURE containing widget ids.
;               value : STRING droplist value
;
; Opt. Inputs : None.
;
; Outputs     : res   : FLAG indicating QUIT.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;                 Added OPEN CD.
;                 Added OPEN EDB DAT, OPEN HK DAT.
;                 Changed OPEN to OPEN GSEOS.
;                 Moved reset_files to reset and reset on quit.
;                 Added save of info on BATCH mode command.
;                 Added BATCH IF command.
;                 Added CONCATENATE IF
;               Version 0.2, 6/2/01
;                 Added PEDESTAL and ESPCT IF data set
;               Version 0.3, 10/2/01
;                 Changed batch to common block.
;                 Changed start to common block.
;                 Added OPEN DAT option.
;               Version 0.4, 21/2/01
;                 Changed batch --> auto.
;               Version 0.5, 5/3/01
;                 Added TRIM IF command.
;               Version 0.6, 9/3/01
;                 Added SAVE/RESTORE IF CFG commands.
;                 Added SPCT survey plot option.
;                 Added 4SC IIMS survey plot option.
;               Version 0.7, 14/3/01
;                 Removed ids from rcs_text and rcs_concatenate argument lists.
;               Version 0.8, 22/3/01
;                 Moved setting of auto for batch IF processing into this routine.
;               Version 0.9, 08/04/01
;                 Added REPROCESS IF.
;               Version 1.0, 03/05/01
;                 Added RESTORE_SINGLE_IF command.
;                 Added DETECTOR vs SCETOR survey plot.
;               Version 1.1, 10/05/01
;                 Used repocess_if=3 option.
;               Version 1.2, 15/05/01
;                 Added CLEANBM2.
;                 Changed restore IF configuration code.
;                 Added IES BM survey plot.
;               Version 1.3, 31/05/01
;                 Changed meaning of auto flag..
;               Version 1.4, 26/06/01
;                 Added IES CLEAN survey plot.
;               Version 1.5, 08/02/02
;                 Added EPAD2.
;               Version 1.6, 14/05/02
;                 Added PA, LINE and OCC 4SC survey plots.
;               Version 1.7, 12/07/02
;                 Added SCI data source.
;                 Removed ids from rcs_batch_if argument list
;               Version 1.8, 17/01/03
;                 Changed rcs_add_cd and rcs_add_dat to functions..
;               Version 1.9, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 1.9, 09/10/03
;-
;**********************************************************

FUNCTION rcs_menu, ids, value

  CASE value OF

    'MENU.START' : BEGIN

               ; set started flag

               rcs_set_start, 1

               rcs_sensitive, ids.spacecraft, 0

             END

    'MENU.AUTO' : BEGIN

               ; set started flag

               rcs_set_start, 1

               rcs_sensitive, ids.spacecraft, 0

               ; set auto flag

               rcs_set_auto, 3

             END

    'MENU.PROCESS SCI' : BEGIN

               rcs_batch_sci

             END

    'MENU.PROCESS IF' : BEGIN

               ; set auto

               rcs_set_auto, 3

               rcs_batch_if

             END

    'MENU.REPROCESS IF' : BEGIN

               ; set auto

               rcs_set_auto, 4

               rcs_batch_if, REPROCESS_IF=3

             END

    'MENU.CONCATENATE IF' : rcs_concatenate_if

    'MENU.AUTO IF' : BEGIN

               ; set started flag

               rcs_set_start, 1

               rcs_sensitive, ids.spacecraft, 0

               ; set auto flag

               rcs_set_auto, 4

             END

     'MENU.OPEN GSEOS' : rcs_add_files, ids, WHERE(ids.in.type EQ 'GSEOS')

     'MENU.OPEN NM' : rcs_add_files, ids, WHERE(ids.in.type EQ 'NM')

     'MENU.OPEN BM' : rcs_add_files, ids, WHERE(ids.in.type EQ 'BM')

     'MENU.OPEN HK' : rcs_add_files, ids, WHERE(ids.in.type EQ 'HK')

     'MENU.OPEN CD' : dummy = rcs_add_cd(ids)

     'MENU.OPEN DAT' : dummy = rcs_add_dat(ids)

     'MENU.OPEN EDB' : rcs_add_files, ids, WHERE(ids.in.type EQ 'EDB')

     'MENU.STOP' : BEGIN

                    rcs_set_start, 0

                    rcs_set_auto, 0

                 END

     'MENU.SAVE_IF' : rcs_save_if

     'MENU.RESTORE_IF' : rcs_restore_if, ids

     'MENU.RESTORE_SINGLE_IF' : rcs_restore_if, ids, /SINGLE

     'MENU.RESTORE_DAT' : rcs_restore_dat, ids

     'MENU.TRIM IF' : rcs_trim_if, ids

     'MENU.RESET' : BEGIN

              ; reset text window

               rcs_text, 'RESET', /RESET

               ; reset files, common blocks and display

               rcs_reset, ids, /FILES

               WIDGET_CONTROL, ids.block, SET_BUTTON=0

               rcs_set_start, 0

               rcs_set_auto, 0

               rcs_sensitive, ids.spacecraft, 1

               ; set silent button off

               rcs_silent, ids, 0

           END

     'MENU.RESET_TEXT' : BEGIN

               ; reset text window

               rcs_text, 'TEXT RESET', /RESET

            END

     'MENU.QUIT' : BEGIN

               ; close any open files

               rcs_reset, ids, /FILES

               WIDGET_CONTROL, ids.base, /DESTROY

               RETURN, 1

             END

     'MENU.PLOT' : BEGIN

             ; get output_info

             WIDGET_CONTROL, ids.info, GET_VALUE=output_info

             ; start up panel

             IF output_info.noutputs GT 0 THEN dummy = rcs_panel(output_info)

             ; start up any other widgets

             dummy = rcs_widget(output_info)

           END

     'MENU.SAVE_CONFIGURATION' : BEGIN

             WIDGET_CONTROL, ids.info, GET_VALUE=output_info

             file = ies_pickfile(TITLE='SAVE CONFIGURATION',FILTER=['*.cfg'],COUNT=count,PATH=ies_get_dir('CFG',/RAPID))

             IF count NE 1 THEN RETURN, 0

             SAVE, output_info, FILE=file

           END

     'MENU.RESTORE_CONFIGURATION' : BEGIN

             output_info = rcs_restore_cfg()

             IF KEYWORD_SET(output_info) THEN BEGIN

               ; set output info

               WIDGET_CONTROL, ids.info, SET_VALUE=output_info


             ENDIF

           END

     'MENU.SAVE_IF_CONFIGURATION' : BEGIN

             file = ies_pickfile(TITLE='SAVE IF CONFIGURATION',FILTER=['*.ifc'],COUNT=count,PATH=ies_get_dir('IFCFG',/RAPID))

             IF count NE 1 THEN RETURN, 0

             use = rcs_get_use()

             SAVE, use, FILE=file

           END

     'MENU.RESTORE_IF_CONFIGURATION' : rcs_restore_use

     'MENU.SURVEY.WIN.IES' : rcs_survey, TYPE=0

     'MENU.SURVEY.WIN.CLEAN' : rcs_survey, TYPE=5

     'MENU.SURVEY.WIN.IIMS' : rcs_survey, TYPE=1

     'MENU.SURVEY.WIN.SGL' : rcs_survey, TYPE=2

     'MENU.SURVEY.WIN.SPCT' : rcs_survey, TYPE=3

     'MENU.SURVEY.WIN.IESBM' : rcs_survey, TYPE=4

     'MENU.SURVEY.WIN.4SC.IES' : rcs_4sc_survey, TYPE=0

     'MENU.SURVEY.WIN.4SC.IIMS' : rcs_4sc_survey, TYPE=1

     'MENU.SURVEY.WIN.4SC.POL' : rcs_4sc_survey, TYPE=2

     'MENU.SURVEY.WIN.4SC.PA' : rcs_4sc_survey, TYPE=3

     'MENU.SURVEY.WIN.4SC.LINE' : rcs_4sc_survey, TYPE=4

     'MENU.SURVEY.WIN.4SC.OCC' : rcs_4sc_survey, TYPE=5

     'MENU.SURVEY.PS.IES' : rcs_survey, TYPE=0, /PS

     'MENU.SURVEY.PS.CLEAN' : rcs_survey, TYPE=5, /PS

     'MENU.SURVEY.PS.IIMS' : rcs_survey, TYPE=1, /PS

     'MENU.SURVEY.PS.SGL' : rcs_survey, TYPE=2, /PS

     'MENU.SURVEY.PS.SPCT' : rcs_survey, TYPE=3, /PS

     'MENU.SURVEY.PS.IESBM' : rcs_survey, TYPE=4, /PS

     'MENU.SURVEY.PS.4SC.IES' : rcs_4sc_survey, TYPE=0, /PS

     'MENU.SURVEY.PS.4SC.IIMS' : rcs_4sc_survey, TYPE=1, /PS

     'MENU.SURVEY.PS.4SC.POL' : rcs_4sc_survey, TYPE=2, /PS

     'MENU.SURVEY.PS.4SC.PA' : rcs_4sc_survey, TYPE=3, /PS

     'MENU.SURVEY.PS.4SC.LINE' : rcs_4sc_survey, TYPE=4, /PS

     'MENU.SURVEY.PS.4SC.OCC' : rcs_4sc_survey, TYPE=5, /PS

     'MENU.SURVEY.GIF.IES' : rcs_survey, TYPE=0, /GIF

     'MENU.SURVEY.GIF.CLEAN' : rcs_survey, TYPE=5, /GIF

     'MENU.SURVEY.GIF.IIMS' : rcs_survey, TYPE=1, /GIF

     'MENU.SURVEY.GIF.SGL' : rcs_survey, TYPE=2, /GIF

     'MENU.SURVEY.GIF.SPCT' : rcs_survey, TYPE=3, /GIF

     'MENU.SURVEY.GIF.IESBM' : rcs_survey, TYPE=4, /GIF

     'MENU.SURVEY.GIF.4SC.IES' : rcs_4sc_survey, TYPE=0, /GIF

     'MENU.SURVEY.GIF.4SC.IIMS' : rcs_4sc_survey, TYPE=1, /GIF

     'MENU.SURVEY.GIF.4SC.POL' : rcs_4sc_survey, TYPE=2, /GIF

     'MENU.SURVEY.GIF.4SC.PA' : rcs_4sc_survey, TYPE=3, /GIF

     'MENU.SURVEY.GIF.4SC.LINE' : rcs_4sc_survey, TYPE=4, /GIF

     'MENU.SURVEY.GIF.4SC.OCC' : rcs_4sc_survey, TYPE=5, /GIF

     'MENU.SURVEY.PNG.IES' : rcs_survey, TYPE=0, /PNG

     'MENU.SURVEY.PNG.CLEAN' : rcs_survey, TYPE=5, /PNG

     'MENU.SURVEY.PNG.IIMS' : rcs_survey, TYPE=1, /PNG

     'MENU.SURVEY.PNG.SGL' : rcs_survey, TYPE=2, /PNG

     'MENU.SURVEY.PNG.SPCT' : rcs_survey, TYPE=3, /PNG

     'MENU.SURVEY.PNG.IESBM' : rcs_survey, TYPE=4, /PNG

     'MENU.SURVEY.PNG.4SC.IES' : rcs_4sc_survey, TYPE=0, /PNG

     'MENU.SURVEY.PNG.4SC.IIMS' : rcs_4sc_survey, TYPE=1, /PNG

     'MENU.SURVEY.PNG.4SC.POL' : rcs_4sc_survey, TYPE=2, /PNG

     'MENU.SURVEY.PNG.4SC.PA' : rcs_4sc_survey, TYPE=3, /PNG

     'MENU.SURVEY.PNG.4SC.LINE' : rcs_4sc_survey, TYPE=4, /PNG

     'MENU.SURVEY.PNG.4SC.OCC' : rcs_4sc_survey, TYPE=5, /PNG

     'MENU.RAL PLOT TOOL.E-3DD' : rcs_ies_plot, /E3DDNM

     'MENU.RAL PLOT TOOL.E-3DDBM' : rcs_ies_plot, /E3DDBM

     'MENU.RAL PLOT TOOL.E-PAD' : rcs_ies_plot, /EPAD

     'MENU.RAL PLOT TOOL.E-PAD2' : rcs_ies_plot, /E2PAD

     'MENU.RAL PLOT TOOL.E-HIST' : rcs_ies_plot, /EHIST

     'MENU.RAL PLOT TOOL.CLEAN' : rcs_ies_plot, /NM_CLEAN

     'MENU.RAL PLOT TOOL.CLEANBM' : rcs_ies_plot, /BM_CLEAN

     'MENU.RAL PLOT TOOL.CLEANBM2' : rcs_ies_plot, /BM2_CLEAN

     'MENU.RAL PLOT TOOL.ESPCT' : rcs_ies_plot, /ESPCT

     'MENU.RAL PLOT TOOL.PEDESTAL' : rcs_ies_plot, /PEDESTAL

     'MENU.RAL PLOT TOOL.E-HK' : rcs_ies_plot, /EHK

     'MENU.RAL PLOT TOOL.HK1' : rcs_ies_plot, /HK1

     'MENU.RAL PLOT TOOL.HK2' : rcs_ies_plot, /HK2

     'MENU.RAL PLOT TOOL.HK4' : rcs_ies_plot, /HK4

     'MENU.RAL PLOT TOOL.HK8' : rcs_ies_plot, /HK8

     'MENU.RAL PLOT TOOL.HK32' : rcs_ies_plot, /HK32

     'MENU.RAL PLOT TOOL.I-3DD-H' : rcs_ies_plot, /I3DD_H

     'MENU.RAL PLOT TOOL.I-3DD-He': rcs_ies_plot, /I3DDHE

     'MENU.RAL PLOT TOOL.I-3DD-CNO' : rcs_ies_plot, /I3DDCNO

     'MENU.RAL PLOT TOOL.I-PAD' : rcs_ies_plot, /IPAD

     'MENU.RAL PLOT TOOL.HSPCT' : rcs_ies_plot, /HSPCT

     'MENU.RAL PLOT TOOL.ISPCT-He' : rcs_ies_plot, /ISPCTHE

     'MENU.RAL PLOT TOOL.ISPCT-CNO' : rcs_ies_plot, /ISPCTCNO

     'MENU.RAL PLOT TOOL.MTRX' : rcs_ies_plot, /MTRX

     'MENU.RAL PLOT TOOL.SGLBM' : rcs_ies_plot, /SGLBM

     'MENU.RAL PLOT TOOL.SGL01' : rcs_ies_plot, /SGL01

     'MENU.RAL PLOT TOOL.SGL2' : rcs_ies_plot, /SGL2

     'MENU.RAL PLOT TOOL.SGL3' : rcs_ies_plot, /SGL3

     'MENU.RAL PLOT TOOL.MIS' : rcs_ies_plot, /MIS

     'MENU.COLOR'   : xloadct, GROUP = ids.base

     ELSE : dummy = DIALOG_MESSAGE( 'Unknown item : ' + value )

  ENDCASE

  RETURN, 0

END
