;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MESSAGE
;
; Purpose     :	Wrapper around MESSAGE procedure.
;
; Explanation : Wrapper around MESSAGE procedure.
;
; Use         : < rcs_message, message >
;
; Inputs      : message   : STRING error message
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : INFORMATIONAL  : Flag indicating error message only informational.
;               TRACEBACK      : Flag indicating traceback given.
;               CONTINUE       : Flag indicating continue.
;               IMPLEMENTATION : Flag indicating implemenattion error.
;
; Written     :	Version 0.0, 21/08/03
;
; Modified    : Version 0.1, 24/09/03
;                 Forced traceback if implentation error.
;
; Version     :	Version 0.1, 24/09/03
;-
;**********************************************************

PRO rcs_message, message, INFORMATIONAL=informational, TRACEBACK=traceback, CONTINUE=continue, IMPLEMENTATION=implementation

  IF KEYWORD_SET(implementation) THEN BEGIN

    IF KEYWORD_SET(message) THEN message = 'IMPLEMENTATION ERROR -- '+message ELSE message = 'IMPLEMENTATION ERROR'

    traceback = 1

  ENDIF

  rcs_text, message, /OVERRIDE

  MESSAGE, message, INFORMATIONAL=informational, TRACEBACK=traceback, CONTINUE=continue

END
