;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_MIN_SECTOR
;
; Purpose     :	Works out the position of the sector containing the minimum m value.
;
; Use         : < RCS_FIND_M, s, b, mp >
;
; Inputs      : mvals : BYTARR containing the [8]BYTE m values determining the detectors
;                       for each sector, [2]BYTE msigns determining B-field parallel or 
;                       anti-parallel.
;
; Opt. Inputs : None.
;
; Outputs     : mag : [2]FLTARR giving magnetic field azimuth and polar angles.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 27/02/02
;
; Modified    :
;
; Version     :	Version 0.0, 27/02/02
;-
;**********************************************************

FUNCTION rcs_min_sector, m

  ; find minimum points

  list = WHERE(m EQ MIN(m), count)
  
  IF count EQ 1 THEN RETURN, list[0]

  ; get longest run

  run_start = list[0]
  run_length = 1
  max_run_length = 0

  FOR k = 1, count-1 DO BEGIN

    IF list[k] EQ list[k-1]+1 THEN BEGIN

      ; increment run length

      run_length = run_length + 1

    ENDIF ELSE BEGIN

      ; finish old run

      IF run_length GT max_run_length THEN BEGIN

        max_run_length = run_length

        max_run_start = run_start

      ENDIF
      
      ; start new run

      run_start = list[k]

      run_length = 1

    ENDELSE

  ENDFOR

  ; finish last run

  IF list[count-1] EQ 15 THEN BEGIN

    IF run_start EQ 0 THEN RETURN, 8

    k = 0

    WHILE list[k] EQ k DO k = k + 1

    run_length = run_length + k

  ENDIF

  IF run_length GT max_run_length THEN BEGIN

    max_run_length = run_length

    max_run_start = run_start

  ENDIF
      
  RETURN, (max_run_start+(run_length-1)/2.) MOD 16

END

