;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PED_PROCESS_IF
;
; Purpose     :
;
; Explanation :
;
; Use         : < rcs_ped_process_if, sc, day, type >
;
; Inputs      : sc     : STRING character giving SC.
;               day    : STRING day
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/05/02
;
; Modified    : Version 0.1, 04/01/03
;                 Changed rcs_time_average to FUNCTION.
;
; Version     :	Version 0.1, 04/01/03
;-
;**********************************************************

PRO rcs_ped_process_if, sc, day, PED_PROCESS=ped_process

  COMMON rcs_ped_process_block, peds

  ; check processing options

  IF 1 THEN BEGIN

    ; process pedestal data

    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IES_PEDESTAL', day, ped_header, ped_data) THEN BEGIN

      IF rcs_time_average( ped_header.tstart, ped_header.tstop, ped_data.time, $
        REFORM(ped_data.data[0,*,*],ped_header.ndetectors,ped_header.nbands,ped_header.npoints), $
                        atime, adata, PERIOD=3600, POINTS=points) THEN BEGIN

        ; insist on a substantial no. of points

        vlist = WHERE(points GT 10, vcount)

        IF vcount GT 0 THEN BEGIN

          new = REPLICATE({time:0.0d0,data:FLTARR(ped_header.ndetectors,ped_header.nbands)},vcount)

          new.time = atime[vlist]
          new.data = REFORM(adata[*,*,vlist],ped_header.ndetectors,ped_header.nbands,vcount)

          IF KEYWORD_SET(peds) THEN peds = [peds,new] ELSE peds = new

        ENDIF

      ENDIF

    ENDIF

  ENDIF

END
