;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESET
;
; Purpose     :	Resets RCS display and common blocks.
;
; Explanation : Resets RCS display and common blocks.
;
; Use         : < rcs_reset, ids >
;
; Inputs      : ids   : STRUCTURE containging widget ids.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILES : flag indicating files reset also.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 24/1/01
;                 Included reset files.
;               Version 0.2, 12/2/01
;                 Used save previous.
;
; Version     :	Version 0.1, 24/1/01
;-
;**********************************************************

PRO rcs_reset, ids, FILES=files

  ; reset files

  IF KEYWORD_SET(files) THEN rcs_reset_files, ids

  ; reset display

  rcs_reset_display, ids

  ; reset data COMMON blocks

  rcs_reset_cm

  rcs_reset_if

  rcs_set_edb_count, 0

  ; initialize previous

  rcs_set_previous, 0, /SC

  rcs_set_previous, 0, /HK

END
