;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SENSITIVE
;
; Purpose     :	Sets sensitivity of widget.
;
; Explanation : Sets sensitivity of widget.
;
; Use         : < rcs_sensitive, widget_id, sensitive >
;
; Inputs      : widget_if : LONG widget ID.
;               sensitive : INT flag indicating sensitivity.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
;
; Written     :	Version 0.0, Martin Carter, RAL, 19/1/01
;
; Modified    :	Version 0.1, 21/2/01
;                 Added check for valid widget ID.
;
; Version     :	Version 0.1, 21/2/01
;-
;**********************************************************

PRO rcs_sensitive, widget_id, sensitive

  ; check if id valid

  IF NOT WIDGET_INFO(widget_id,/VALID_ID) THEN RETURN

  IF rcs_version() THEN BEGIN

    WIDGET_CONTROL, widget_id, SENSITIVE=sensitive

  ENDIF ELSE BEGIN

    WIDGET_CONTROL, widget_id, SENSITIVE=sensitive

  ENDELSE

END
