;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SILENT
;
; Purpose     :	Manages silent running.
;
; Explanation : Manages silent running.
;
; Use         : < rcs_silent, ids, value >
;
; Inputs      : ids   : STRUCTURE containing widget ids.
;               value : FLAG indicating whether silent or not.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 26/1/01
;                 Added file.
;            	Version 0.2, 10/2/01
;                 Changed silent flag to common block.
;            	Version 0.3, 22/07/02
;                 Allowed no .in tag.
;
; Version     :	Version 0.3, 22/07/02
;-
;**********************************************************

PRO rcs_silent, ids, value

  rcs_set_silent, value

  rcs_sensitive, ids.sc, 1-value

  rcs_sensitive, ids.hk, 1-value

  IF ies_tag_exists(ids,'IN') THEN BEGIN

    FOR k=0, N_ELEMENTS(ids.in)-1 DO BEGIN

      rcs_sensitive, ids.in[k].file, 1-value

      rcs_sensitive, ids.in[k].bytes, 1-value

      rcs_sensitive, ids.in[k].time, 1-value

    ENDFOR

    ; update files

    IF NOT rcs_get_silent() THEN BEGIN

      FOR k = 0, N_ELEMENTS(ids.in)-1 DO BEGIN

        ; restore file names

        files = rcs_get_files(k)

        ; display file names

        rcs_set_files, k, files

      ENDFOR

    ENDIF

  ENDIF

END
