;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_STRFIND
;
; Purpose     :	Checks if string contains specified substring.
;
; Explanation : Checks if string contains specified substring.
;
; Use         : < res = rcs_strfind(str, substr) >
;
; Inputs      : str    : STRING
;               substr : STRING
;
; Opt. Inputs : None.
;
; Outputs     : res : FLAG
;
; Opt. Outputs: None.
;
; Keywords    : POS : LONG position of end of substring in string
;
; Written     :	Version 0.0, 05/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 05/07/02
;-
;**********************************************************

FUNCTION rcs_strfind, str, substr, POS=pos

  start_pos = STRPOS(str,substr)

  pos = start_pos + STRLEN(substr)

  RETURN, start_pos GE 0

END
