;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_STRMERGE
;
; Purpose     :	Merges array into string containing separated values.
;
; Explanation : Merges array of strings into string containing separated values.
;
; Use         : < str = rcs_strmerge(array, delimiter) >
;
; Inputs      : array     : ARRAY() values.
;               delimiter : STRING delimiter
;
; Opt. Inputs : None.
;
; Outputs     : str             : STRING delimiter separated values
;
; Opt. Outputs: None.
;
; Keywords    : ST = STRING start delimiter
;               EN = STRING end delimiter
;
; Written     :	Version 0.0, 20/07/02
;
; Modified    : 
;
; Version     :	Version 0.0, 20/07/02
;-
;**********************************************************

FUNCTION rcs_strmerge, array, delimiter, ST=st, EN=en 

  ; test if start/end delimiters null or ''

  IF NOT KEYWORD_SET(st) THEN st = ''

  IF NOT KEYWORD_SET(en) THEN en = ''

  str = st

  FOR k=0, N_ELEMENTS(array)-2 DO str = str+rcs_strtrim(array[k])+delimiter

  str = str+rcs_strtrim(last_item(array))

  str = str+en
  
  RETURN, str

END
