;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_STRSPLIT
;
; Purpose     :	Splits string containing separated values into array of values.
;
; Explanation : Splits string containing separated values into array of values.
;               i.e str = '     (1,2,3,4)  '
;                   start_delimiter = '('
;                   end_delimiter = ')'
;                   delimiter = ','
;                   array = [1,2,3,4]
;
; Use         : < array = rcs_strsplit(str, start_delimiter, end_delimiter, delimiter) >
;
; Inputs      : str             : STRING delimiter separated values
;               start_delimiter : STRING end delimiter
;               end_delimiter   : STRING end delimiter
;               delimiter       : STRING delimiter
;
; Opt. Inputs : None.
;
; Outputs     : array : LONARR() integer values.
;
; Opt. Outputs: None.
;
; Keywords    : FLOAT : FLAG indicating FLOAT values
;               INT   : FLAG indicating INT values
;               LONG  : FLAG indicating LONG values
;
; Written     :	Version 0.0, 05/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 05/07/02
;-
;**********************************************************

FUNCTION rcs_strsplit, str, start_delimiter, end_delimiter, delimiter, FLOAT=fl, INT=in, LONG=lo

  ; test if start/end delimiters null or ''

  IF NOT KEYWORD_SET(start_delimiter) THEN s = 0 ELSE s = STRPOS(str,start_delimiter)+1

  IF NOT KEYWORD_SET(end_delimiter) THEN e = STRLEN(str)-1 ELSE e = STRPOS(str,end_delimiter)-1

  ; check

  IF e LT s THEN BEGIN

    rcs_message, 'STRING PARSING ERROR', /INFORMATIONAL

    RETURN, 0

  ENDIF

  ; split string

  str0 = STRMID(str,s,e-s+1)

  IF KEYWORD_SET(delimiter) THEN $
    str1 = STRSPLIT(str0,delimiter,/EXTRACT) $
  ELSE $
    str1 = STRSPLIT(str0,/EXTRACT)

  IF KEYWORD_SET(fl) THEN array = FLOAT(str1) ELSE $
  IF KEYWORD_SET(in) THEN array = FIX(str1) ELSE $
  IF KEYWORD_SET(lo) THEN array = LONG(str1) ELSE $
    array = str1

  RETURN, array

END
