;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SUN_OFFSETS
;
; Purpose     :	Gets sun offsets for each sample point.
;               GSE to SC coords gives azimuth angle relative to sun direction.
;               When in sun direction azimuth angle = offset by definition.
;               Sector 0 begins when reference direction points at sun.
;               This is set by command to be 26.367 degrees after sun reference pulse.
;               Sun sensor is actually 26.2 degrees away from reference direction.
;               Rapid is 60.0 from reference direction.
;               Offset of sector 0 is -60.167 degrees.
;
; Use         : < offsets = rcs_sun_offsets(sc, times) >
;
; Inputs      : sc  : STRING character giving SC
;               times : DBLARR TAI times
;
; Opt. Inputs : None.
;
; Outputs     : offsets : FLTARR giving sun offsets for each time.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 30/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 30/07/02
;-
;**********************************************************

FUNCTION rcs_sun_offsets, sc, times

  ; innacurate routine for now
  ; returns the angle of RAPID relative to the sun when the sun sensor is
  ; 26.367 deg past the sun
  ; (ie when reference direction is pretty much pointing at the sun)


  RETURN, REPLICATE(-60.167/180.0*!PI, N_ELEMENTS(times))

END

