;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_TEMP_PROCESS_IF
;
; Purpose     :
;
; Explanation :
;
; Use         : < rcs_temp_process_if, sc, day, type >
;
; Inputs      : sc     : STRING character giving SC.
;               day    : STRING day
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 04/07/01
;
; Modified    : Version 0.1, 20/07/01
;                 Changed name argument for day.
;               Version 0.2, 13/03/02
;                 Changed sc argument to sc_root in rcs_restore_ifdata.
;               Version 0.3, 04/01/03
;                 Changed rcs_time_average to FUNCTION.
;
; Version     :	Version 0.3, 04/01/03
;-
;**********************************************************

PRO rcs_temp_process_if, sc, day, TEMP_PROCESS=temp_process

  COMMON rcs_temp_process_block, temps

  ; check processing options

  IF 1 THEN BEGIN

    ; process HK8 data

    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'HK8', day, hk8_header, hk8_data) THEN BEGIN

      ; HK8 :
      ; 'ERDGNDRF','ERIP5VRF','ERIM5VRF','ERIP12RF','ERIM12RF','ERISAREF','ERISTREF','ERIHKTRF'

      IF rcs_time_average( hk8_header.tstart, hk8_header.tstop, hk8_data.time, REFORM(hk8_data.data[0,6:7],2,1,hk8_header.npoints), $
                        atime, adata, PERIOD=3600, POINTS=points) THEN BEGIN

        ; insist on a substantial no. of points

        vlist = WHERE(points GT 10, vcount)

        IF vcount GT 0 THEN BEGIN

          new = REPLICATE({time:0.0d0,data:FLTARR(2)},vcount)

          new.time = atime[vlist]
          new.data = REFORM(adata[*,0,vlist],2,vcount)

          IF KEYWORD_SET(temps) THEN temps = [temps,new] ELSE temps = new

        ENDIF

      ENDIF

    ENDIF

  ENDIF

END
