;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TEST_MP
;
; Purpose     :	Works out the magnetic field in the SC reference frame for the M values
;               and M signs over a spin.
;               The m-value is the polar direction of the perpendicular to the B-field
;               expressed as 0-15 with 0 along the SC spin_axis.
;               At 90 degrees to this is the direction closest to the B field direction.
;               The sense of this is determined from the M-sign.
;
; Use         : < RCS_FIND_M, s, b, mp >
;
; Inputs      : mvals : BYTARR containing the [8]BYTE m values determining the detectors
;                       for each sector, [2]BYTE msigns determining B-field parallel or 
;                       anti-parallel.
;
; Opt. Inputs : None.
;
; Outputs     : mag : [2]FLTARR giving magnetic field azimuth and polar angles.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 27/02/02
;
; Modified    :	;
; Version     :	Version 0.0, 27/02/02
;-
;**********************************************************

FUNCTION rcs_test_mp, b

  ; find projection of B field onto sector plane

  ; set up mvectors 0 - 31

  th = (0.5+FINDGEN(32))*!PI/16

  ; set up sector plane azimuth angles

  ph = (0.5+INDGEN(16))*2*!PI/16

  ; set up B field

  bth = b[1]
  bph = b[0]

  ;  find B azimuth relative to sectorplane

  bph = bph - ph

  bx = SIN(bth)*COS(bph)
  by = SIN(bth)*SIN(bph)
  bz = COS(bth)

  ; find dot product of B with sector plane

  dot = bx#SIN(th) + REPLICATE(bz,16)#COS(th)

  ; find max 

  mp = INTARR(16)

  FOR s = 0, 15 DO BEGIN

    dummy = MAX(dot[s,*],m)

    mp[s] = m

  ENDFOR

  RETURN, mp

END

